/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.ClockBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClockBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty HOUR = ModBlockProperties.HOUR;

    public ClockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static void displayCurrentHour(Level world, Player player) {
        int time = (int)(world.m_46468_() + 6000L) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!ClientConfigs.Blocks.CLOCK_24H.get().booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        player.m_5661_((Component)Component.m_237113_((String)(h + ":" + (m < 10 ? "0" : "") + m + a)), true);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.m_5776_()) {
            ClockBlock.displayCurrentHour(worldIn, player);
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ClockBlockTile(pPos, pState);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            if (world.m_7702_(pos) instanceof ClockBlockTile) {
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HOUR, FACING, WATERLOGGED});
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (world.m_6042_().f_63858_() && (blockEntity = world.m_7702_(pos)) instanceof ClockBlockTile) {
            ClockBlockTile tile = (ClockBlockTile)blockEntity;
            return tile.getPower();
        }
        return 0;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ClockBlockTile) {
            ClockBlockTile tile = (ClockBlockTile)blockEntity;
            tile.updateInitialTime(worldIn, state, pos);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.CLOCK_BLOCK_TILE.get(), ClockBlockTile::tick);
    }
}

