/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model.baked;

import com.mojang.math.Vector3f;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.render.ConstantsCable;
import com.refinedmods.refinedstorage.render.model.CubeBuilder;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;

public class CableCoverBakedModel
extends BakedModelWrapper<BakedModel> {
    private static TextureAtlasSprite BORDER_SPRITE;

    public CableCoverBakedModel(BakedModel base) {
        super(base);
    }

    private static int getHollowCoverSize(@Nullable BlockState state, Direction coverSide) {
        if (state == null) {
            return 6;
        }
        BaseBlock block = (BaseBlock)state.m_60734_();
        if (block == RSBlocks.CABLE.get()) {
            return 6;
        }
        if (block.getDirection() != null && state.m_61143_((Property)block.getDirection().getProperty()) == coverSide) {
            if (block == RSBlocks.EXPORTER.get()) {
                return 6;
            }
            if (block == RSBlocks.EXTERNAL_STORAGE.get() || block == RSBlocks.IMPORTER.get()) {
                return 3;
            }
            if (block == RSBlocks.CONSTRUCTOR.get() || block == RSBlocks.DESTRUCTOR.get()) {
                return 2;
            }
        }
        return 6;
    }

    protected static void addCover(List<BakedQuad> quads, @Nullable Cover cover, Direction coverSide, Direction side, RandomSource rand, @Nullable CoverManager manager, BlockState state, boolean handle) {
        if (cover == null) {
            return;
        }
        BlockState coverState = CoverManager.getBlockState(cover.getStack());
        if (coverState == null) {
            return;
        }
        boolean hasUp = false;
        boolean hasDown = false;
        boolean hasEast = false;
        boolean hasWest = false;
        if (manager != null) {
            hasUp = manager.hasCover(Direction.UP);
            hasDown = manager.hasCover(Direction.DOWN);
            hasEast = manager.hasCover(Direction.EAST);
            hasWest = manager.hasCover(Direction.WEST);
        }
        switch (cover.getType()) {
            case NORMAL: {
                CableCoverBakedModel.addNormalCover(quads, coverState, coverSide, hasUp, hasDown, hasEast, hasWest, handle, rand);
                break;
            }
            case HOLLOW: {
                CableCoverBakedModel.addHollowCover(quads, coverState, coverSide, hasUp, hasDown, hasEast, hasWest, CableCoverBakedModel.getHollowCoverSize(state, coverSide), rand);
            }
        }
    }

    private static void addNormalCover(List<BakedQuad> quads, BlockState state, Direction coverSide, boolean hasUp, boolean hasDown, boolean hasEast, boolean hasWest, boolean handle, RandomSource random) {
        AABB bounds = ConstantsCable.getCoverBounds(coverSide);
        Vector3f from = new Vector3f((float)bounds.f_82288_ * 16.0f, (float)bounds.f_82289_ * 16.0f, (float)bounds.f_82290_ * 16.0f);
        Vector3f to = new Vector3f((float)bounds.f_82291_ * 16.0f, (float)bounds.f_82292_ * 16.0f, (float)bounds.f_82293_ * 16.0f);
        if (coverSide == Direction.NORTH) {
            if (hasWest) {
                from.setX(2.0f);
            }
            if (hasEast) {
                to.setX(14.0f);
            }
        } else if (coverSide == Direction.SOUTH) {
            if (hasWest) {
                from.setX(2.0f);
            }
            if (hasEast) {
                to.setX(14.0f);
            }
        }
        if (coverSide.m_122434_() != Direction.Axis.Y) {
            if (hasDown) {
                from.setY(2.0f);
            }
            if (hasUp) {
                to.setY(14.0f);
            }
        }
        HashMap spriteCache = new HashMap();
        quads.addAll(new CubeBuilder().from(from.m_122239_(), from.m_122260_(), from.m_122269_()).to(to.m_122239_(), to.m_122260_(), to.m_122269_()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.m_91087_().m_91289_().m_110910_(state), state, direction, random)))).bake());
        if (handle) {
            if (BORDER_SPRITE == null) {
                BORDER_SPRITE = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("refinedstorage", "block/cable_part_border"));
            }
            bounds = ConstantsCable.getHolderBounds(coverSide);
            from = new Vector3f((float)bounds.f_82288_ * 16.0f, (float)bounds.f_82289_ * 16.0f, (float)bounds.f_82290_ * 16.0f);
            to = new Vector3f((float)bounds.f_82291_ * 16.0f, (float)bounds.f_82292_ * 16.0f, (float)bounds.f_82293_ * 16.0f);
            quads.addAll(new CubeBuilder().from(from.m_122239_(), from.m_122260_(), from.m_122269_()).to(to.m_122239_(), to.m_122260_(), to.m_122269_()).addFaces(face -> new CubeBuilder.Face((Direction)face, BORDER_SPRITE)).bake());
        }
    }

    private static void addHollowCover(List<BakedQuad> quads, BlockState state, Direction coverSide, boolean hasUp, boolean hasDown, boolean hasEast, boolean hasWest, int size, RandomSource random) {
        AABB bounds = ConstantsCable.getCoverBounds(coverSide);
        Vector3f from = new Vector3f((float)bounds.f_82288_ * 16.0f, (float)bounds.f_82289_ * 16.0f, (float)bounds.f_82290_ * 16.0f);
        Vector3f to = new Vector3f((float)bounds.f_82291_ * 16.0f, (float)bounds.f_82292_ * 16.0f, (float)bounds.f_82293_ * 16.0f);
        if (coverSide.m_122434_() != Direction.Axis.Y) {
            if (hasDown) {
                from.setY(2.0f);
            }
            if (hasUp) {
                to.setY(14.0f);
            }
        }
        if (coverSide == Direction.NORTH) {
            if (hasWest) {
                from.setX(2.0f);
            } else {
                from.setX(0.0f);
            }
            to.setX((float)size);
        } else if (coverSide == Direction.SOUTH) {
            if (hasEast) {
                to.setX(14.0f);
            } else {
                to.setX(16.0f);
            }
            from.setX((float)(16 - size));
        } else if (coverSide == Direction.EAST) {
            from.setZ(0.0f);
            to.setZ((float)size);
        } else if (coverSide == Direction.WEST) {
            from.setZ((float)(16 - size));
            to.setZ(16.0f);
        } else if (coverSide == Direction.DOWN || coverSide == Direction.UP) {
            from.setZ((float)(16 - size));
            to.setZ(16.0f);
        }
        HashMap spriteCache = new HashMap();
        quads.addAll(new CubeBuilder().from(from.m_122239_(), from.m_122260_(), from.m_122269_()).to(to.m_122239_(), to.m_122260_(), to.m_122269_()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.m_91087_().m_91289_().m_110910_(state), state, direction, random)))).bake());
        if (coverSide == Direction.NORTH) {
            if (hasEast) {
                to.setX(14.0f);
            } else {
                to.setX(16.0f);
            }
            from.setX((float)(16 - size));
        } else if (coverSide == Direction.SOUTH) {
            if (hasWest) {
                from.setX(2.0f);
            } else {
                from.setX(0.0f);
            }
            to.setX((float)size);
        } else if (coverSide == Direction.EAST) {
            from.setZ((float)(16 - size));
            to.setZ(16.0f);
        } else if (coverSide == Direction.WEST) {
            from.setZ(0.0f);
            to.setZ((float)size);
        } else if (coverSide == Direction.DOWN || coverSide == Direction.UP) {
            from.setZ(0.0f);
            to.setZ((float)size);
        }
        quads.addAll(new CubeBuilder().from(from.m_122239_(), from.m_122260_(), from.m_122269_()).to(to.m_122239_(), to.m_122260_(), to.m_122269_()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.m_91087_().m_91289_().m_110910_(state), state, direction, random)))).bake());
        if (coverSide == Direction.NORTH) {
            from.setX((float)size);
            to.setX((float)(16 - size));
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == Direction.SOUTH) {
            from.setX((float)size);
            to.setX((float)(16 - size));
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == Direction.EAST) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == Direction.WEST) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == Direction.DOWN || coverSide == Direction.UP) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            from.setX(0.0f);
            to.setX((float)size);
        }
        quads.addAll(new CubeBuilder().from(from.m_122239_(), from.m_122260_(), from.m_122269_()).to(to.m_122239_(), to.m_122260_(), to.m_122269_()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.m_91087_().m_91289_().m_110910_(state), state, direction, random)))).bake());
        if (coverSide == Direction.NORTH) {
            from.setX((float)size);
            to.setX((float)(16 - size));
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY((float)(16 - size));
        } else if (coverSide == Direction.SOUTH) {
            from.setX((float)size);
            to.setX((float)(16 - size));
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY((float)(16 - size));
        } else if (coverSide == Direction.EAST) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY((float)(16 - size));
        } else if (coverSide == Direction.WEST) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY((float)(16 - size));
        } else if (coverSide == Direction.DOWN || coverSide == Direction.UP) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            from.setX((float)(16 - size));
            to.setX(16.0f);
        }
        quads.addAll(new CubeBuilder().from(from.m_122239_(), from.m_122260_(), from.m_122269_()).to(to.m_122239_(), to.m_122260_(), to.m_122269_()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.m_91087_().m_91289_().m_110910_(state), state, direction, random)))).bake());
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData, renderType));
        if (extraData.has(CoverManager.PROPERTY)) {
            CoverManager manager = (CoverManager)extraData.get(CoverManager.PROPERTY);
            CableCoverBakedModel.addCover(quads, manager.getCover(Direction.NORTH), Direction.NORTH, side, rand, manager, state, true);
            CableCoverBakedModel.addCover(quads, manager.getCover(Direction.SOUTH), Direction.SOUTH, side, rand, manager, state, true);
            CableCoverBakedModel.addCover(quads, manager.getCover(Direction.EAST), Direction.EAST, side, rand, manager, state, true);
            CableCoverBakedModel.addCover(quads, manager.getCover(Direction.WEST), Direction.WEST, side, rand, manager, state, true);
            CableCoverBakedModel.addCover(quads, manager.getCover(Direction.DOWN), Direction.DOWN, side, rand, manager, state, true);
            CableCoverBakedModel.addCover(quads, manager.getCover(Direction.UP), Direction.UP, side, rand, manager, state, true);
        }
        return quads;
    }
}

