/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.sync;

import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.container.BaseContainerMenu;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class BlockEntitySynchronizationParamaterUpdateMessage {
    private final BlockEntitySynchronizationParameter parameter;
    private final Object value;

    public BlockEntitySynchronizationParamaterUpdateMessage(BlockEntitySynchronizationParameter parameter, Object value) {
        this.parameter = parameter;
        this.value = value;
    }

    public static BlockEntitySynchronizationParamaterUpdateMessage decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        BlockEntitySynchronizationParameter parameter = BlockEntitySynchronizationManager.getParameter(id);
        Object value = null;
        if (parameter != null) {
            try {
                value = parameter.getSerializer().m_6709_(buf);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new BlockEntitySynchronizationParamaterUpdateMessage(parameter, value);
    }

    public static void encode(BlockEntitySynchronizationParamaterUpdateMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.parameter.getId());
        message.parameter.getSerializer().m_6856_(buf, message.value);
    }

    public static void handle(BlockEntitySynchronizationParamaterUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BiConsumer consumer;
            AbstractContainerMenu c = ((NetworkEvent.Context)ctx.get()).getSender().f_36096_;
            if (c instanceof BaseContainerMenu && (consumer = message.parameter.getValueConsumer()) != null) {
                consumer.accept(((BaseContainerMenu)c).getBlockEntity(), (BaseBlockEntity)((Object)((Object)message.value)));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

