/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.apiimpl.network.node.DetectorNetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.DetectorScreen;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DetectorBlockEntity
extends NetworkNodeBlockEntity<DetectorNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, DetectorBlockEntity> COMPARE = IComparable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, DetectorBlockEntity> TYPE = IType.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, DetectorBlockEntity> MODE = new BlockEntitySynchronizationParameter<Integer, DetectorBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((DetectorNetworkNode)t.getNode()).getMode(), (t, v) -> {
        if (v == 0 || v == 1 || v == 2) {
            ((DetectorNetworkNode)t.getNode()).setMode((int)v);
            ((DetectorNetworkNode)t.getNode()).markDirty();
        }
    });
    public static final BlockEntitySynchronizationParameter<Integer, DetectorBlockEntity> AMOUNT = new BlockEntitySynchronizationParameter<Integer, DetectorBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((DetectorNetworkNode)t.getNode()).getAmount(), (t, v) -> {
        ((DetectorNetworkNode)t.getNode()).setAmount((int)v);
        ((DetectorNetworkNode)t.getNode()).markDirty();
    }, (initial, value) -> BaseScreen.executeLater(DetectorScreen.class, detectorScreen -> detectorScreen.updateAmountField((int)value)));
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addWatchedParameter(COMPARE).addWatchedParameter(TYPE).addWatchedParameter(MODE).addWatchedParameter(AMOUNT).build();
    private static final String NBT_POWERED = "Powered";

    public DetectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RSBlockEntities.DETECTOR.get(), pos, state, SPEC, DetectorNetworkNode.class);
    }

    @Override
    public void readUpdate(CompoundTag tag) {
        ((DetectorNetworkNode)this.getNode()).setPowered(tag.m_128471_(NBT_POWERED));
        super.readUpdate(tag);
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag) {
        super.writeUpdate(tag);
        tag.m_128379_(NBT_POWERED, ((DetectorNetworkNode)this.getNode()).isPowered());
        return tag;
    }

    @Override
    @Nonnull
    public DetectorNetworkNode createNode(Level level, BlockPos pos) {
        return new DetectorNetworkNode(level, pos);
    }
}

