/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.capabilities;

import com.direwolf20.charginggadgets.blocks.chargingstation.ChargingStationTile;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class ChargerEnergyStorage
implements IEnergyStorage,
INBTSerializable<CompoundTag> {
    private static final String KEY = "energy";
    private int energy;
    private int capacity;
    private int maxInOut = 1000000;
    private ChargingStationTile tile;

    public ChargerEnergyStorage(ChargingStationTile tile, int energy, int capacity) {
        this.energy = energy;
        this.capacity = capacity;
        this.tile = tile;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(KEY, this.energy);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.energy = nbt.m_128451_(KEY);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxInOut, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.tile.m_6596_();
        }
        return energyReceived;
    }

    public int consumeEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.maxInOut, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public String toString() {
        return "ChargerEnergyStorage{energy=" + this.energy + ", capacity=" + this.capacity + ", maxInOut=" + this.maxInOut + "}";
    }
}

