/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.core.util.Pair;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CGPaneBakedModel
extends BakedModelWrapper<BakedModel> {
    private static final int VERTEX_POSITION_OFFSET = CGPaneBakedModel.findPositionOffset(DefaultVertexFormat.f_85811_);
    private static final ModelProperty<Pair<BlockState, BlockState>> MODEL_PROPERTY = new ModelProperty();

    public CGPaneBakedModel(BakedModel originalModel) {
        super(originalModel);
    }

    public BakedModel applyTransform(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        super.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
        return this;
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return List.of(this);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        return super.getModelData(level, pos, state, modelData).derive().with(MODEL_PROPERTY, (Object)Pair.of((Object)level.m_8055_(pos.m_7494_()), (Object)level.m_8055_(pos.m_7495_()))).build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        if (state == null || !data.has(MODEL_PROPERTY)) {
            return super.getQuads(state, side, rand, data, renderType);
        }
        BlockState stateAbove = (BlockState)((Pair)data.get(MODEL_PROPERTY)).left();
        BlockState stateBelow = (BlockState)((Pair)data.get(MODEL_PROPERTY)).right();
        return super.getQuads(state, side, rand, data, renderType).stream().filter(quad -> CGPaneBakedModel.filterQuad(quad, state, stateAbove, stateBelow)).collect(Collectors.toList());
    }

    private static boolean filterQuad(BakedQuad quad, BlockState self, BlockState stateAbove, BlockState stateBelow) {
        Direction quadDirection = quad.m_111306_();
        if (quadDirection != Direction.UP && quadDirection != Direction.DOWN) {
            return true;
        }
        float[] quadCenter = CGPaneBakedModel.getQuadCenter(quad.m_111303_());
        double quadDistance = Math.sqrt(((double)quadCenter[0] - 0.5) * ((double)quadCenter[0] - 0.5) + ((double)quadCenter[2] - 0.5) * ((double)quadCenter[2] - 0.5));
        if (quadDistance < 0.1) {
            return quadDirection == Direction.UP ? stateAbove.m_60734_() != self.m_60734_() : stateBelow.m_60734_() != self.m_60734_();
        }
        Direction partSide = Direction.m_122372_((float)(quadCenter[0] - 0.5f), (float)0.0f, (float)(quadCenter[2] - 0.5f));
        return quadDirection == Direction.UP ? stateAbove.m_60734_() != self.m_60734_() || !((Boolean)stateAbove.m_61143_((Property)CGPaneBlock.getConnectionProperty(partSide))).booleanValue() : stateBelow.m_60734_() != self.m_60734_() || (Boolean)stateBelow.m_61143_((Property)CGPaneBlock.getConnectionProperty(partSide)) == false;
    }

    private static float[] getQuadCenter(int[] vertexData) {
        int vertexSize = DefaultVertexFormat.f_85811_.m_86017_();
        int vertices = vertexData.length / vertexSize;
        int positionOffset = VERTEX_POSITION_OFFSET / 4;
        float averageX = 0.0f;
        float averageY = 0.0f;
        float averageZ = 0.0f;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + positionOffset;
            averageX += Float.intBitsToFloat(vertexData[offset]);
            averageY += Float.intBitsToFloat(vertexData[offset + 1]);
            averageZ += Float.intBitsToFloat(vertexData[offset + 2]);
        }
        return new float[]{averageX /= (float)vertices, averageY /= (float)vertices, averageZ /= (float)vertices};
    }

    private static int findPositionOffset(VertexFormat vertexFormat) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < vertexFormat.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.POSITION) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.m_86023_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a POSITION attribute");
        }
        if (element.m_86041_() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected POSITION attribute to have data type FLOAT");
        }
        if (element.m_86050_() != 12) {
            throw new RuntimeException("Expected POSITION attribute to have 3 dimensions");
        }
        return vertexFormat.getOffset(index);
    }
}

