/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.google.gson.JsonObject;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.IUpgradeBase;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public final class TurtleToolSerialiser
implements TurtleUpgradeSerialiser<TurtleTool> {
    public static final TurtleToolSerialiser INSTANCE = new TurtleToolSerialiser();

    private TurtleToolSerialiser() {
    }

    @Override
    @Nonnull
    public TurtleTool fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject object) {
        String adjective = GsonHelper.m_13851_((JsonObject)object, (String)"adjective", (String)IUpgradeBase.getDefaultAdjective(id));
        Item toolItem = GsonHelper.m_13909_((JsonObject)object, (String)"item");
        Item craftingItem = GsonHelper.m_144746_((JsonObject)object, (String)"craftingItem", (Item)toolItem);
        float damageMultiplier = GsonHelper.m_13820_((JsonObject)object, (String)"damageMultiplier", (float)3.0f);
        TagKey breakable = null;
        if (object.has("breakable")) {
            ResourceLocation tag = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"breakable"));
            breakable = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tag);
        }
        return new TurtleTool(id, adjective, craftingItem, new ItemStack((ItemLike)toolItem), damageMultiplier, (TagKey<Block>)breakable);
    }

    @Override
    @Nonnull
    public TurtleTool fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
        String adjective = buffer.m_130277_();
        Item craftingItem = (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
        ItemStack toolItem = buffer.m_130267_();
        float damageMultiplier = buffer.readFloat();
        TagKey breakable = buffer.readBoolean() ? TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)buffer.m_130281_()) : null;
        return new TurtleTool(id, adjective, craftingItem, toolItem, damageMultiplier, (TagKey<Block>)breakable);
    }

    @Override
    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull TurtleTool upgrade) {
        buffer.m_130070_(upgrade.getUnlocalisedAdjective());
        buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)upgrade.getCraftingItem().m_41720_());
        buffer.m_130055_(upgrade.item);
        buffer.writeFloat(upgrade.damageMulitiplier);
        buffer.writeBoolean(upgrade.breakable != null);
        if (upgrade.breakable != null) {
            buffer.m_130085_(upgrade.breakable.f_203868_());
        }
    }
}

