/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class TurtleDropCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleDropCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        ItemStack stack = turtle.getInventory().m_7407_(turtle.getSelectedSlot(), this.quantity);
        if (stack.m_41619_()) {
            return TurtleCommandResult.failure("No items to drop");
        }
        turtle.getInventory().m_6596_();
        Level world = turtle.getLevel();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.m_121945_(direction);
        Direction side = direction.m_122424_();
        IItemHandler inventory = InventoryUtil.getInventory(world, newPosition, side);
        if (inventory != null) {
            ItemStack remainder = InventoryUtil.storeItems(stack, inventory);
            if (!remainder.m_41619_()) {
                InventoryUtil.storeItems(remainder, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.WAIT);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        WorldUtil.dropItemStack(stack, world, oldPosition, direction);
        world.m_6798_(1000, newPosition, 0);
        turtle.playAnimation(TurtleAnimation.WAIT);
        return TurtleCommandResult.success();
    }
}

