/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.peripheral.printer.BlockPrinter;
import dan200.computercraft.shared.peripheral.printer.ContainerPrinter;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DefaultSidedInventory;
import dan200.computercraft.shared.util.SidedCaps;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.NetworkHooks;

public final class TilePrinter
extends TileGeneric
implements DefaultSidedInventory,
Nameable,
MenuProvider {
    private static final String NBT_NAME = "CustomName";
    private static final String NBT_PRINTING = "Printing";
    private static final String NBT_PAGE_TITLE = "PageTitle";
    static final int SLOTS = 13;
    private static final int[] BOTTOM_SLOTS = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] TOP_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SIDE_SLOTS = new int[]{0};
    Component customName;
    private LockCode lockCode = LockCode.f_19102_;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)13, (Object)ItemStack.f_41583_);
    private final SidedCaps<IItemHandler> itemHandlerCaps = SidedCaps.ofNullable(facing -> facing == null ? new InvWrapper((Container)this) : new SidedInvWrapper((WorldlyContainer)this, facing));
    private LazyOptional<IPeripheral> peripheralCap;
    private final NetworkedTerminal page = new NetworkedTerminal(25, 21, true);
    private String pageTitle = "";
    private boolean printing = false;

    public TilePrinter(BlockEntityType<TilePrinter> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void destroy() {
        this.ejectContents();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCaps.invalidate();
        this.peripheralCap = CapabilityUtil.invalidate(this.peripheralCap);
    }

    @Override
    public boolean isUsable(Player player) {
        return super.isUsable(player) && BaseContainerBlockEntity.m_58629_((Player)player, (LockCode)this.lockCode, (Component)this.m_5446_());
    }

    @Override
    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_58904_().f_46443_ && this.isUsable(player)) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
        }
        return InteractionResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.customName = nbt.m_128441_(NBT_NAME) ? Component.Serializer.m_130701_((String)nbt.m_128461_(NBT_NAME)) : null;
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            this.printing = nbt.m_128471_(NBT_PRINTING);
            this.pageTitle = nbt.m_128461_(NBT_PAGE_TITLE);
            this.page.readFromNBT(nbt);
        }
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.lockCode = LockCode.m_19111_((CompoundTag)nbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_183515_(@Nonnull CompoundTag nbt) {
        if (this.customName != null) {
            nbt.m_128359_(NBT_NAME, Component.Serializer.m_130703_((Component)this.customName));
        }
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            nbt.m_128379_(NBT_PRINTING, this.printing);
            nbt.m_128359_(NBT_PAGE_TITLE, this.pageTitle);
            this.page.writeToNBT(nbt);
        }
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        this.lockCode.m_19109_(nbt);
        super.m_183515_(nbt);
    }

    boolean isPrinting() {
        return this.printing;
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        ItemStack result = (ItemStack)this.inventory.get(slot);
        this.inventory.set(slot, (Object)ItemStack.f_41583_);
        this.m_6596_();
        this.updateBlockState();
        return result;
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41613_() <= count) {
            this.m_6836_(slot, ItemStack.f_41583_);
            return stack;
        }
        ItemStack part = stack.m_41620_(count);
        if (((ItemStack)this.inventory.get(slot)).m_41619_()) {
            this.inventory.set(slot, (Object)ItemStack.f_41583_);
            this.updateBlockState();
        }
        this.m_6596_();
        return part;
    }

    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.m_6596_();
        this.updateBlockState();
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.f_41583_);
        }
        this.m_6596_();
        this.updateBlockState();
    }

    @Override
    public boolean m_7013_(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return TilePrinter.isInk(stack);
        }
        if (slot >= TOP_SLOTS[0] && slot <= TOP_SLOTS[TOP_SLOTS.length - 1]) {
            return TilePrinter.isPaper(stack);
        }
        return false;
    }

    public boolean m_6542_(@Nonnull Player playerEntity) {
        return this.isUsable(playerEntity);
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction side) {
        switch (side) {
            case DOWN: {
                return BOTTOM_SLOTS;
            }
            case UP: {
                return TOP_SLOTS;
            }
        }
        return SIDE_SLOTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Terminal getCurrentPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            return this.printing ? this.page : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNewPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            if (!this.canInputPage()) {
                return false;
            }
            if (this.printing && !this.outputPage()) {
                return false;
            }
            return this.inputPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endCurrentPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            return this.printing && this.outputPage();
        }
    }

    int getInkLevel() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        return TilePrinter.isInk(inkStack) ? inkStack.m_41613_() : 0;
    }

    int getPaperLevel() {
        int count = 0;
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = (ItemStack)this.inventory.get(i);
            if (!TilePrinter.isPaper(paperStack)) continue;
            count += paperStack.m_41613_();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPageTitle(String title) {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            if (this.printing) {
                this.pageTitle = title;
            }
        }
    }

    static boolean isInk(@Nonnull ItemStack stack) {
        return ColourUtils.getStackColour(stack) != null;
    }

    static boolean isPaper(@Nonnull ItemStack stack) {
        ItemPrintout printout;
        Item item = stack.m_41720_();
        return item == Items.f_42516_ || item instanceof ItemPrintout && (printout = (ItemPrintout)item).getType() == ItemPrintout.Type.PAGE;
    }

    private boolean canInputPage() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        return !inkStack.m_41619_() && TilePrinter.isInk(inkStack) && this.getPaperLevel() > 0;
    }

    private boolean inputPage() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        DyeColor dye = ColourUtils.getStackColour(inkStack);
        if (dye == null) {
            return false;
        }
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = (ItemStack)this.inventory.get(i);
            if (paperStack.m_41619_() || !TilePrinter.isPaper(paperStack)) continue;
            this.page.setTextColour(dye.m_41060_());
            this.page.clear();
            if (paperStack.m_41720_() instanceof ItemPrintout) {
                this.pageTitle = ItemPrintout.getTitle(paperStack);
                String[] text = ItemPrintout.getText(paperStack);
                String[] textColour = ItemPrintout.getColours(paperStack);
                for (int y = 0; y < this.page.getHeight(); ++y) {
                    this.page.setLine(y, text[y], textColour[y], "");
                }
            } else {
                this.pageTitle = "";
            }
            this.page.setCursorPos(0, 0);
            inkStack.m_41774_(1);
            if (inkStack.m_41619_()) {
                this.inventory.set(0, (Object)ItemStack.f_41583_);
            }
            paperStack.m_41774_(1);
            if (paperStack.m_41619_()) {
                this.inventory.set(i, (Object)ItemStack.f_41583_);
                this.updateBlockState();
            }
            this.m_6596_();
            this.printing = true;
            return true;
        }
        return false;
    }

    private boolean outputPage() {
        int height = this.page.getHeight();
        String[] lines = new String[height];
        String[] colours = new String[height];
        for (int i = 0; i < height; ++i) {
            lines[i] = this.page.getLine(i).toString();
            colours[i] = this.page.getTextColourLine(i).toString();
        }
        ItemStack stack = ItemPrintout.createSingleFromTitleAndText(this.pageTitle, lines, colours);
        for (int slot : BOTTOM_SLOTS) {
            if (!((ItemStack)this.inventory.get(slot)).m_41619_()) continue;
            this.m_6836_(slot, stack);
            this.printing = false;
            return true;
        }
        return false;
    }

    private void ejectContents() {
        for (int i = 0; i < 13; ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.m_41619_()) continue;
            this.m_6836_(i, ItemStack.f_41583_);
            WorldUtil.dropItemStack(stack, this.m_58904_(), Vec3.m_82528_((Vec3i)this.m_58899_()).m_82520_(0.5, 0.75, 0.5));
        }
    }

    private void updateBlockState() {
        ItemStack stack;
        int i;
        boolean top = false;
        boolean bottom = false;
        for (i = 1; i < 7; ++i) {
            stack = (ItemStack)this.inventory.get(i);
            if (stack.m_41619_() || !TilePrinter.isPaper(stack)) continue;
            top = true;
            break;
        }
        for (i = 7; i < 13; ++i) {
            stack = (ItemStack)this.inventory.get(i);
            if (stack.m_41619_() || !TilePrinter.isPaper(stack)) continue;
            bottom = true;
            break;
        }
        this.updateBlockState(top, bottom);
    }

    private void updateBlockState(boolean top, boolean bottom) {
        if (this.f_58859_ || this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)BlockPrinter.TOP) == top & (Boolean)state.m_61143_((Property)BlockPrinter.BOTTOM) == bottom) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)((BlockState)state.m_61124_((Property)BlockPrinter.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)BlockPrinter.BOTTOM, (Comparable)Boolean.valueOf(bottom)));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerCaps.get(facing).cast();
        }
        if (capability == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> new PrinterPeripheral(this));
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    @Nonnull
    public Component m_7755_() {
        return this.customName != null ? this.customName : Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nonnull
    public Component m_5446_() {
        return super.m_5446_();
    }

    @Nonnull
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
        return new ContainerPrinter(id, inventory, this);
    }
}

