/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;

public final class ColourableRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<?> SERIALIZER = new SimpleRecipeSerializer(ColourableRecipe::new);

    private ColourableRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean hasColourable = false;
        boolean hasDye = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IColouredItem) {
                if (hasColourable) {
                    return false;
                }
                hasColourable = true;
                continue;
            }
            if (ColourUtils.getStackColour(stack) != null) {
                hasDye = true;
                continue;
            }
            return false;
        }
        return hasColourable && hasDye;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack colourable = ItemStack.f_41583_;
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IColouredItem) {
                colourable = stack;
                continue;
            }
            DyeColor dye = ColourUtils.getStackColour(stack);
            if (dye == null) continue;
            tracker.addColour(dye);
        }
        if (colourable.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ((IColouredItem)colourable.m_41720_()).withColour(colourable, tracker.getColour());
        stack.m_41764_(1);
        return stack;
    }

    public boolean m_8004_(int x, int y) {
        return x >= 2 && y >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

