/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.SlaughterFactoryConfig;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SlaughterFactoryTile
extends IndustrialAreaWorkingTile<SlaughterFactoryTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedFluidTankComponent<SlaughterFactoryTile> meat = (SidedFluidTankComponent)new SidedFluidTankComponent("meat", SlaughterFactoryConfig.maxMeatTankSize, 43, 20, 0).setColor(DyeColor.BROWN).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ModuleCore.MEAT.getSourceFluid().get()));
    @Save
    private SidedFluidTankComponent<SlaughterFactoryTile> pinkSlime;

    public SlaughterFactoryTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.SLAUGHTER_FACTORY, RangeManager.RangeType.BEHIND, true, SlaughterFactoryConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.meat);
        this.pinkSlime = (SidedFluidTankComponent)new SidedFluidTankComponent("pink_slime", SlaughterFactoryConfig.maxPinkSlimeTankSize, 63, 20, 1).setColor(DyeColor.PINK).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get()));
        this.addTank(this.pinkSlime);
        this.maxProgress = SlaughterFactoryConfig.maxProgress;
        this.powerPerOperation = SlaughterFactoryConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List<Mob> mobs;
        if (this.hasEnergy(this.powerPerOperation) && (mobs = this.f_58857_.m_45976_(Mob.class, this.getWorkingArea().m_83215_()).stream().filter(LivingEntity::m_6084_).filter(mob -> !mob.m_20147_() && !mob.m_6095_().m_204039_(IndustrialTags.EntityTypes.SLAUGHTER_FACTORY_BLACKLIST)).toList()).size() > 0) {
            Mob entity = mobs.get(0);
            float currentHealth = entity.m_21223_();
            entity.m_142687_(Entity.RemovalReason.KILLED);
            if (!entity.m_6084_()) {
                this.meat.fillForced(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), entity instanceof Animal ? (int)currentHealth : (int)currentHealth * 20), IFluidHandler.FluidAction.EXECUTE);
                this.pinkSlime.fillForced(new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), entity instanceof Animal ? (int)(currentHealth * 20.0f) : (int)currentHealth), IFluidHandler.FluidAction.EXECUTE);
                return new IndustrialWorkingTile.WorkAction(this, 0.2f, this.powerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<SlaughterFactoryTile> createEnergyStorage() {
        return new EnergyStorageComponent(SlaughterFactoryConfig.maxStoredPower, 10, 20);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.f_58858_, this.getFacingDirection(), RangeManager.RangeType.BEHIND){

            @Override
            public AABB getBox() {
                return super.getBox().m_82363_(0.0, 2.0, 0.0);
            }
        }.get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public SlaughterFactoryTile getSelf() {
        return this;
    }
}

