/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter.network;

import java.util.function.Supplier;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncHandItem {
    private final ItemStack stack;

    public PacketSyncHandItem(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
    }

    public PacketSyncHandItem(Player player) {
        this.stack = player.m_21120_(InteractionHand.MAIN_HAND);
    }

    protected boolean isValidItem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof FilterModuleItem || itemStack.m_41720_() instanceof TabletItem;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer playerEntity = ctx.getSender();
            ItemStack heldItem = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
            if (heldItem.m_41619_()) {
                return;
            }
            if (!this.isValidItem(heldItem)) {
                return;
            }
            if (!this.isValidItem(this.stack)) {
                return;
            }
            playerEntity.m_21008_(InteractionHand.MAIN_HAND, this.stack);
        });
        ctx.setPacketHandled(true);
    }
}

