/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.data;

import appeng.core.AppEng;
import me.ramidzkh.mekae2.AMItems;
import me.ramidzkh.mekae2.AppliedMekanistics;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelProvider
extends net.minecraftforge.client.model.generators.ItemModelProvider {
    private static final ResourceLocation P2P_TUNNEL_BASE_ITEM = AppEng.makeId((String)"item/p2p_tunnel_base");
    private static final ResourceLocation P2P_TUNNEL_BASE_PART = AppEng.makeId((String)"part/p2p/p2p_tunnel_base");
    private static final ResourceLocation STORAGE_CELL_LED = AppEng.makeId((String)"item/storage_cell_led");
    private static final ResourceLocation PORTABLE_CELL_LED = AppEng.makeId((String)"item/portable_cell_led");
    private static final ResourceLocation OSMIUM_BLOCK = new ResourceLocation("mekanism", "block/block_osmium");

    public ItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "appmek", existingFileHelper);
        existingFileHelper.trackGenerated(P2P_TUNNEL_BASE_ITEM, (ExistingFileHelper.IResourceType)MODEL);
        existingFileHelper.trackGenerated(P2P_TUNNEL_BASE_PART, (ExistingFileHelper.IResourceType)MODEL);
        existingFileHelper.trackGenerated(STORAGE_CELL_LED, (ExistingFileHelper.IResourceType)TEXTURE);
        existingFileHelper.trackGenerated(PORTABLE_CELL_LED, (ExistingFileHelper.IResourceType)TEXTURE);
        existingFileHelper.trackGenerated(OSMIUM_BLOCK, (ExistingFileHelper.IResourceType)TEXTURE);
    }

    protected void registerModels() {
        RegistryObject<Item> housing = AMItems.CHEMICAL_CELL_HOUSING;
        this.flatSingleLayer(housing, "item/" + housing.getId().m_135815_());
        RegistryObject<Item> creative = AMItems.CHEMICAL_CELL_CREATIVE;
        this.flatSingleLayer(creative, "item/" + creative.getId().m_135815_());
        for (AMItems.Tier tier : AMItems.Tier.values()) {
            RegistryObject<Item> cell = AMItems.get(tier);
            RegistryObject<Item> portableCell = AMItems.getPortableCell(tier);
            this.cell(cell, "item/" + cell.getId().m_135815_());
            this.portableCell(portableCell, "item/portable_" + cell.getId().m_135815_());
        }
        ((ItemModelBuilder)this.withExistingParent("item/chemical_p2p_tunnel", P2P_TUNNEL_BASE_ITEM)).texture("type", OSMIUM_BLOCK);
        ((ItemModelBuilder)this.withExistingParent("part/chemical_p2p_tunnel", P2P_TUNNEL_BASE_PART)).texture("type", OSMIUM_BLOCK);
    }

    private void cell(RegistryObject<Item> cell, String background) {
        ((ItemModelBuilder)this.singleTexture(cell.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", AppliedMekanistics.id(background))).texture("layer1", STORAGE_CELL_LED);
    }

    private void portableCell(RegistryObject<Item> portable, String background) {
        ((ItemModelBuilder)this.singleTexture(portable.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", AppliedMekanistics.id(background))).texture("layer1", PORTABLE_CELL_LED);
    }

    private void flatSingleLayer(RegistryObject<Item> item, String texture) {
        this.singleTexture(item.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", AppliedMekanistics.id(texture));
    }
}

