/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.menu;

import com.google.common.base.Suppliers;
import earth.terrarium.chipped.common.recipe.ChippedRecipe;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ChippedMenu
extends AbstractContainerMenu {
    final Slot inputSlot;
    final Slot resultSlot;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private final ResultContainer resultContainer = new ResultContainer();
    private final MenuType<ChippedMenu> containerType;
    private ChippedRecipe recipe;
    private Supplier<List<ItemStack>> results;
    private ItemStack input = ItemStack.f_41583_;
    private long lastSoundTime;
    private Runnable slotUpdateListener = () -> {};
    private RecipeType<ChippedRecipe> recipeType;
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            ChippedMenu.this.m_6199_((Container)this);
            ChippedMenu.this.slotUpdateListener.run();
        }
    };
    private Block blockWorkbench;

    public ChippedMenu(int id, Inventory inventory, ContainerLevelAccess posCallable, MenuType<ChippedMenu> container, RecipeType<ChippedRecipe> recipe, Block block) {
        this(container, id, inventory, posCallable);
        this.recipeType = recipe;
        this.blockWorkbench = block;
    }

    public ChippedMenu(MenuType<ChippedMenu> container, int id, Inventory inventory, final ContainerLevelAccess posCallable) {
        super(container, id);
        this.containerType = container;
        this.access = posCallable;
        this.level = inventory.f_35978_.f_19853_;
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
                stack.m_41678_(player.f_19853_, player, stack.m_41613_());
                ChippedMenu.this.resultContainer.m_8015_(player);
                ItemStack itemstack = ChippedMenu.this.inputSlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    ChippedMenu.this.setupResultSlot();
                }
                posCallable.m_39292_((p_216954_1_, p_216954_2_) -> {
                    long l = p_216954_1_.m_46467_();
                    if (ChippedMenu.this.lastSoundTime != l) {
                        p_216954_1_.m_5594_(null, p_216954_2_, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ChippedMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(player, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<ItemStack> getResults() {
        return this.results == null ? Collections.emptyList() : this.results.get();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && this.results != null;
    }

    public boolean m_6875_(@NotNull Player player) {
        return ChippedMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockWorkbench);
    }

    public boolean m_6366_(@NotNull Player player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.m_6422_(index);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.getResults().size();
    }

    public void m_6199_(@NotNull Container inventory) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        if (itemstack.m_41720_() != this.input.m_41720_()) {
            this.input = itemstack.m_41777_();
            this.setupRecipeList(inventory, itemstack);
        }
    }

    private void setupRecipeList(Container inventory, ItemStack stack) {
        this.results = null;
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipe = this.level.m_7465_().m_44015_(this.recipeType, inventory, this.level).orElse(null);
            if (this.recipe != null) {
                this.results = Suppliers.memoize(() -> this.recipe.getResults(inventory).collect(Collectors.toList()));
            }
        }
    }

    private void setupResultSlot() {
        if (this.recipe != null && this.results != null && !this.results.get().isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            this.resultContainer.m_6029_((Recipe)this.recipe);
            this.resultSlot.m_5852_(this.results.get().get(this.selectedRecipeIndex.m_6501_()).m_41777_());
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @NotNull
    public MenuType<?> m_6772_() {
        return this.containerType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerUpdateListener(Runnable p_217071_1_) {
        this.slotUpdateListener = p_217071_1_;
    }

    public boolean m_5882_(@NotNull ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int p_82846_2_) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(p_82846_2_);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (p_82846_2_ == 1) {
                item.m_7836_(itemstack1, player.f_19853_, player);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (p_82846_2_ == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.level.m_7465_().m_44015_(this.recipeType, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (p_82846_2_ < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : p_82846_2_ < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((p_217079_2_, p_217079_3_) -> this.m_150411_(player, this.container));
    }
}

