/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.events;

import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.events.SimpleEvent;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.minecraft.client.resources.language.LanguageInfo;
import org.jetbrains.annotations.Nullable;

public class AfterLanguageLoadEvent
implements SimpleEvent {
    private final Map<String, String> languageLines;
    private final List<LanguageInfo> languageInfo;

    public AfterLanguageLoadEvent(Map<String, String> lines, List<LanguageInfo> info) {
        this.languageInfo = info;
        this.languageLines = lines;
    }

    @Nullable
    public String getEntry(String key) {
        return this.languageLines.get(key);
    }

    public void addEntry(String key, String translation) {
        if (!this.languageLines.containsKey(key)) {
            this.languageLines.put(key, translation);
        }
    }

    public void addEntries(LangBuilder builder) {
        builder.entries().forEach(this::addEntry);
    }

    public boolean isDefault() {
        return this.languageInfo.stream().anyMatch(l -> l.getCode().equals("en_us"));
    }
}

