/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.texture_renderer;

import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class FrameBufferBackedDynamicTexture
extends AbstractTexture {
    protected final Consumer<FrameBufferBackedDynamicTexture> drawingFunction;
    private boolean initialized = false;
    private RenderTarget frameBuffer;
    private final int width;
    private final int height;
    private final ResourceLocation resourceLocation;
    @Nullable
    private NativeImage cpuImage;

    public FrameBufferBackedDynamicTexture(ResourceLocation resourceLocation, int width, int height, @Nullable Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction) {
        this.width = width;
        this.height = height;
        this.resourceLocation = resourceLocation;
        this.drawingFunction = textureDrawingFunction;
    }

    public FrameBufferBackedDynamicTexture(ResourceLocation resourceLocation, int size, @Nullable Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction) {
        this(resourceLocation, size, size, textureDrawingFunction);
    }

    @ApiStatus.Internal
    public void initialize() {
        this.initialized = true;
        Minecraft.m_91087_().m_91097_().m_118495_(this.resourceLocation, (AbstractTexture)this);
        this.redraw();
    }

    public void redraw() {
        if (!RenderSystem.m_69587_()) {
            RenderSystem.m_69879_(() -> {
                this.m_117966_();
                if (this.drawingFunction != null) {
                    this.drawingFunction.accept(this);
                }
            });
        } else {
            this.m_117966_();
            if (this.drawingFunction != null) {
                this.drawingFunction.accept(this);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void m_6704_(ResourceManager manager) {
    }

    public RenderTarget getFrameBuffer() {
        if (this.frameBuffer == null) {
            this.frameBuffer = new MainTarget(this.width, this.height);
            this.f_117950_ = this.frameBuffer.m_83975_();
        }
        return this.frameBuffer;
    }

    public void bindWrite() {
        this.getFrameBuffer().m_83947_(true);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getTextureLocation() {
        return this.resourceLocation;
    }

    public int m_117963_() {
        return this.getFrameBuffer().m_83975_();
    }

    public void m_117964_() {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(this::clearGlId0);
        } else {
            this.clearGlId0();
        }
    }

    private void clearGlId0() {
        if (this.frameBuffer != null) {
            this.frameBuffer.m_83930_();
            this.frameBuffer = null;
        }
        this.f_117950_ = -1;
    }

    public void close() {
        this.m_117964_();
        if (this.cpuImage != null) {
            this.cpuImage.close();
            this.cpuImage = null;
        }
    }

    public NativeImage getPixels() {
        if (this.cpuImage == null) {
            this.cpuImage = new NativeImage(this.width, this.height, false);
        }
        return this.cpuImage;
    }

    public void download() {
        this.m_117966_();
        this.getPixels().m_85045_(0, false);
    }

    public void upload() {
        if (this.cpuImage != null) {
            this.m_117966_();
            this.cpuImage.m_85040_(0, 0, 0, false);
            this.cpuImage.close();
            this.cpuImage = null;
        } else {
            Moonlight.LOGGER.warn("Trying to upload disposed texture {}", (Object)this.m_117963_());
        }
    }

    public List<Path> saveTextureToFile(Path texturesDir) throws IOException {
        return this.saveTextureToFile(texturesDir, this.resourceLocation.m_135815_().replace("/", "_"));
    }

    public List<Path> saveTextureToFile(Path texturesDir, String name) throws IOException {
        this.m_117966_();
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        ArrayList<Path> textureFiles = new ArrayList<Path>();
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int size = width * height;
        if (size == 0) {
            return List.of();
        }
        BufferedImage bufferedimage = new BufferedImage(width, height, 2);
        Path output = texturesDir.resolve(name + ".png");
        IntBuffer buffer = BufferUtils.createIntBuffer((int)size);
        int[] data = new int[size];
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
        buffer.get(data);
        bufferedimage.setRGB(0, 0, width, height, data, 0, width);
        ImageIO.write((RenderedImage)bufferedimage, "png", output.toFile());
        textureFiles.add(output);
        return textureFiles;
    }
}

