/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Optional;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.core.config.IServerConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerCommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private ServerCommandUtil() {
    }

    public static boolean hasPermissionForCheatMode(ServerPlayer sender, IServerConfig serverConfig) {
        MinecraftServer minecraftServer;
        if (serverConfig.isCheatModeEnabledForCreative() && sender.m_7500_()) {
            return true;
        }
        CommandSourceStack commandSource = sender.m_20203_();
        if (serverConfig.isCheatModeEnabledForOp() && (minecraftServer = sender.m_20194_()) != null) {
            int opPermissionLevel = minecraftServer.m_7022_();
            return commandSource.m_6761_(opPermissionLevel);
        }
        if (serverConfig.isCheatModeEnabledForGive()) {
            return ServerCommandUtil.getGiveCommand((Player)sender).map(giveCommand -> giveCommand.canUse((Object)commandSource)).orElse(false);
        }
        return false;
    }

    public static void executeGive(ServerPacketContext context, ItemStack itemStack, GiveMode giveMode) {
        IServerConfig serverConfig;
        ServerPlayer sender = context.player();
        if (ServerCommandUtil.hasPermissionForCheatMode(sender, serverConfig = context.serverConfig())) {
            if (itemStack.m_41619_()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Player '{} ({})' tried to give an empty ItemStack.", (Object)sender.m_7755_(), (Object)sender.m_20148_());
                }
                return;
            }
            if (giveMode == GiveMode.INVENTORY) {
                ServerCommandUtil.giveToInventory((Player)sender, itemStack);
            } else if (giveMode == GiveMode.MOUSE_PICKUP) {
                ServerCommandUtil.mousePickupItemStack((Player)sender, itemStack);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Player '{} ({})' tried to cheat an ItemStack '{}' but does not have permission.", (Object)sender.m_7755_(), (Object)sender.m_20148_(), (Object)itemStack.m_41611_());
            }
            IConnectionToClient connection = context.connection();
            connection.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void setHotbarSlot(ServerPacketContext context, ItemStack itemStack, int hotbarSlot) {
        IServerConfig serverConfig;
        ServerPlayer sender = context.player();
        if (ServerCommandUtil.hasPermissionForCheatMode(sender, serverConfig = context.serverConfig())) {
            if (itemStack.m_41619_()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Player '{} ({})' tried to set an empty ItemStack to the hotbar slot: {}", (Object)sender.m_7755_(), (Object)sender.m_20148_(), (Object)hotbarSlot);
                }
                return;
            }
            if (!Inventory.m_36045_((int)hotbarSlot)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Player '{} ({})' tried to set slot that is not in the hotbar: {}", (Object)sender.m_7755_(), (Object)sender.m_20148_(), (Object)hotbarSlot);
                }
                return;
            }
            ItemStack stackInSlot = sender.m_150109_().m_8020_(hotbarSlot);
            if (ItemStack.m_41728_((ItemStack)stackInSlot, (ItemStack)itemStack)) {
                return;
            }
            ItemStack itemStackCopy = itemStack.m_41777_();
            sender.m_150109_().m_6836_(hotbarSlot, itemStack);
            sender.f_19853_.m_6263_(null, sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((sender.m_217043_().m_188501_() - sender.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            sender.f_36095_.m_38946_();
            ServerCommandUtil.notifyGive((Player)sender, itemStackCopy);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Player '{} ({})' tried to cheat an item '{}' to their hotbar but does not have permission.", (Object)sender.m_7755_(), (Object)sender.m_20148_(), (Object)itemStack.m_41611_());
            }
            IConnectionToClient connection = context.connection();
            connection.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void mousePickupItemStack(Player sender, ItemStack itemStack) {
        int giveCount;
        AbstractContainerMenu containerMenu = sender.f_36096_;
        ItemStack itemStackCopy = itemStack.m_41777_();
        ItemStack existingStack = containerMenu.m_142621_();
        if (ServerCommandUtil.canStack(existingStack, itemStack)) {
            int newCount = Math.min(existingStack.m_41741_(), existingStack.m_41613_() + itemStack.m_41613_());
            giveCount = newCount - existingStack.m_41613_();
            existingStack.m_41764_(newCount);
        } else {
            containerMenu.m_142503_(itemStack);
            giveCount = itemStack.m_41613_();
        }
        if (giveCount > 0) {
            itemStackCopy.m_41764_(giveCount);
            ServerCommandUtil.notifyGive(sender, itemStackCopy);
            containerMenu.m_38946_();
        }
    }

    public static boolean canStack(ItemStack a, ItemStack b) {
        ItemStack singleStack = a.m_41777_();
        singleStack.m_41764_(1);
        return ItemEntity.m_32026_((ItemStack)singleStack, (ItemStack)b);
    }

    private static void giveToInventory(Player entityplayermp, ItemStack itemStack) {
        ItemStack itemStackCopy = itemStack.m_41777_();
        boolean flag = entityplayermp.m_150109_().m_36054_(itemStack);
        if (flag && itemStack.m_41619_()) {
            itemStack.m_41764_(1);
            ItemEntity entityitem = entityplayermp.m_36176_(itemStack, false);
            if (entityitem != null) {
                entityitem.m_32065_();
            }
            entityplayermp.f_19853_.m_6263_(null, entityplayermp.m_20185_(), entityplayermp.m_20186_(), entityplayermp.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((entityplayermp.m_217043_().m_188501_() - entityplayermp.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            entityplayermp.f_36095_.m_38946_();
        } else {
            ItemEntity entityitem = entityplayermp.m_36176_(itemStack, false);
            if (entityitem != null) {
                entityitem.m_32061_();
                entityitem.m_32047_(entityplayermp.m_20148_());
            }
        }
        ServerCommandUtil.notifyGive(entityplayermp, itemStackCopy);
    }

    private static void notifyGive(Player player, ItemStack stack) {
        if (player.m_20194_() == null) {
            return;
        }
        CommandSourceStack commandSource = player.m_20203_();
        int count = stack.m_41613_();
        Component stackTextComponent = stack.m_41611_();
        Component displayName = player.m_5446_();
        MutableComponent message = Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{count, stackTextComponent, displayName});
        commandSource.m_81354_((Component)message, true);
    }

    private static Optional<CommandNode<CommandSourceStack>> getGiveCommand(Player sender) {
        return Optional.ofNullable(sender.m_20194_()).map(minecraftServer -> {
            Commands commandManager = minecraftServer.m_129892_();
            CommandDispatcher dispatcher = commandManager.m_82094_();
            RootCommandNode root = dispatcher.getRoot();
            return root.getChild("give");
        });
    }
}

