/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.GuiTextLocation;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.StreamSupport;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RewardsUtil {
    private static final List<String> oredicts = new ArrayList<String>();
    private static final String[] possibleModOres = new String[]{"ores/aluminum", "ores/copper", "ores/mythril", "ores/lead", "ores/plutonium", "ores/quartz", "ores/ruby", "ores/salt", "ores/sapphire", "ores/silver", "ores/tin", "ores/uranium", "ores/zinc"};
    public static final Random rand = new Random();
    private static final Block[] wools = new Block[]{Blocks.f_50041_, Blocks.f_50042_, Blocks.f_50096_, Blocks.f_50097_, Blocks.f_50099_, Blocks.f_50100_, Blocks.f_50101_, Blocks.f_50102_, Blocks.f_50103_, Blocks.f_50104_, Blocks.f_50105_, Blocks.f_50106_, Blocks.f_50107_, Blocks.f_50108_, Blocks.f_50109_};

    public static List<String> getOreDicts() {
        return oredicts;
    }

    public static void initData() {
        oredicts.add("ores/gold");
        oredicts.add("ores/iron");
        oredicts.add("ores/lapis");
        oredicts.add("ores/diamond");
        oredicts.add("ores/redstone");
        oredicts.add("ores/emerald");
        oredicts.add("ores/quartz");
        oredicts.add("ores/coal");
        for (String oreDict : possibleModOres) {
            if (!Registry.f_122824_.m_206058_(RewardsUtil.getTagKey(new ResourceLocation("forge", oreDict))).iterator().hasNext()) continue;
            oredicts.add(oreDict);
        }
    }

    public static CommandPart[] executeXCommands(String command, int amount) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new CommandPart(command);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount, int delay) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            CommandPart part = new CommandPart(command);
            part.setDelay(delay);
            toReturn[i] = part;
        }
        return toReturn;
    }

    public static void sendMessageToNearPlayers(Level level, BlockPos pos, int distance, String message) {
        for (int i = 0; i < level.m_6907_().size(); ++i) {
            Player entityplayer = (Player)level.m_6907_().get(i);
            double dist = Math.sqrt(Math.pow((double)pos.m_123341_() - entityplayer.m_20185_(), 2.0) + Math.pow((double)pos.m_123342_() - entityplayer.m_20186_(), 2.0) + Math.pow((double)pos.m_123343_() - entityplayer.m_20189_(), 2.0));
            if (!(dist <= (double)distance)) continue;
            RewardsUtil.sendMessageToPlayer(entityplayer, message);
        }
    }

    public static void sendMessageToAllPlayers(Level level, String message) {
        for (int i = 0; i < level.m_6907_().size(); ++i) {
            Player entityplayer = (Player)level.m_6907_().get(i);
            RewardsUtil.sendMessageToPlayer(entityplayer, message);
        }
    }

    public static void sendMessageToPlayer(Player player, String message) {
        if (player != null) {
            RewardsUtil.sendMessageToPlayer(player, (Component)ComponentWrapper.string(message));
        }
    }

    public static void sendMessageToPlayer(Player player, Component message) {
        if (player != null) {
            player.m_213846_(message);
        }
    }

    public static ItemStack getItemStack(String mod, String itemName, int size) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mod, itemName));
        return item == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)item, size);
    }

    public static Block getBlock(String mod, String blockName) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(mod, blockName));
    }

    public static boolean placeBlock(BlockState b, Level level, BlockPos pos) {
        return RewardsUtil.placeBlock(b, level, pos, 3, false);
    }

    public static boolean placeBlock(BlockState b, Level level, BlockPos pos, boolean ignoreUnbreakable) {
        return RewardsUtil.placeBlock(b, level, pos, 3, ignoreUnbreakable);
    }

    public static boolean placeBlock(BlockState b, Level level, BlockPos pos, int update, boolean ignoreUnbreakable) {
        if (!RewardsUtil.isBlockUnbreakable(level, pos) || ignoreUnbreakable) {
            level.m_7731_(pos, b, update);
            return true;
        }
        return false;
    }

    public static boolean isBlockUnbreakable(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60800_((BlockGetter)level, pos) == -1.0f || CCubesSettings.nonReplaceableBlocks.contains(level.m_8055_(pos));
    }

    public static Enchantment getEnchantSafe(ResourceLocation res) {
        return (Enchantment)RewardsUtil.getRegistryEntrySafe(ForgeRegistries.ENCHANTMENTS, res, ForgeRegistries.ENCHANTMENTS.getDefaultKey());
    }

    public static MobEffect getPotionSafe(ResourceLocation res) {
        return (MobEffect)RewardsUtil.getRegistryEntrySafe(ForgeRegistries.MOB_EFFECTS, res, ForgeRegistries.MOB_EFFECTS.getDefaultKey());
    }

    public static ParticleType<?> getParticleSafe(ResourceLocation res) {
        return (ParticleType)RewardsUtil.getRegistryEntrySafe(ForgeRegistries.PARTICLE_TYPES, res, ForgeRegistries.PARTICLE_TYPES.getDefaultKey());
    }

    public static <T> T getRegistryEntrySafe(IForgeRegistry<T> registry, ResourceLocation key, ResourceLocation defaultReturn) {
        Object val = registry.getValue(key);
        return (T)(val == null ? registry.getValue(defaultReturn) : val);
    }

    public static Block getRandomOre() {
        return RewardsUtil.getRandomOre(new ArrayList<String>());
    }

    public static Block getRandomOre(List<String> blacklist) {
        return RewardsUtil.getRandomOreFromOreDict(RewardsUtil.getRandomOreDict(blacklist));
    }

    public static Block getRandomOreFromOreDict(String oreDict) {
        return RewardsUtil.getRandomElement(Registry.f_122824_.m_206058_(RewardsUtil.getTagKey(new ResourceLocation("forge", oreDict))));
    }

    private static Block getRandomElement(Iterable<Holder<Block>> it) {
        List<Holder<Block>> result = StreamSupport.stream(it.spliterator(), false).toList();
        return (Block)result.get(rand.nextInt(result.size())).m_203334_();
    }

    private static TagKey<Block> getTagKey(ResourceLocation res) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)res);
    }

    public static Block getRandomBlock() {
        return RewardsUtil.randomRegistryEntry(ForgeRegistries.BLOCKS, Blocks.f_50652_);
    }

    public static Item getRandomItem() {
        Item item;
        while ((item = RewardsUtil.randomRegistryEntry(ForgeRegistries.ITEMS, Items.f_42410_)) == null || item.getCreativeTabs().size() == 0) {
        }
        return item;
    }

    public static Enchantment randomEnchantment() {
        return RewardsUtil.randomRegistryEntry(ForgeRegistries.ENCHANTMENTS, Enchantments.f_44977_);
    }

    public static CustomEntry<Enchantment, Integer> getRandomEnchantmentAndLevel() {
        Enchantment ench = RewardsUtil.randomEnchantment();
        int level = rand.nextInt(ench.m_6586_()) + ench.m_44702_();
        return new CustomEntry<Enchantment, Integer>(ench, level);
    }

    public static MobEffect getRandomPotionEffect() {
        return RewardsUtil.randomRegistryEntry(ForgeRegistries.MOB_EFFECTS, MobEffects.f_19619_);
    }

    public static MobEffectInstance getRandomPotionEffectInstance() {
        MobEffect effect = RewardsUtil.getRandomPotionEffect();
        int duration = ((int)Math.round(Math.abs(rand.nextGaussian()) * 5.0) + 3) * 20;
        int amplifier = (int)Math.round(Math.abs(rand.nextGaussian() * 1.5));
        return new MobEffectInstance(effect, duration, amplifier);
    }

    public static Potion getRandomPotionType() {
        return RewardsUtil.randomRegistryEntry(ForgeRegistries.POTIONS, Potions.f_43598_);
    }

    public static <T> T randomRegistryEntry(IForgeRegistry<T> registry, T defaultReturn) {
        Collection entries = registry.getValues();
        Object entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        int iteration = 0;
        while (entry == null) {
            if (++iteration > 100) {
                return defaultReturn;
            }
            entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        }
        return entry;
    }

    public static ItemStack getRandomFirework() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag data = new CompoundTag();
        data.m_128405_("Flight", rand.nextInt(3) + 1);
        ListTag explosionList = new ListTag();
        for (int i = 0; i <= rand.nextInt(2); ++i) {
            CompoundTag explosionData = new CompoundTag();
            explosionData.m_128405_("Type", rand.nextInt(5));
            explosionData.m_128379_("Flicker", rand.nextBoolean());
            explosionData.m_128379_("Trail", rand.nextBoolean());
            int[] colors = new int[rand.nextInt(2) + 1];
            for (int j = 0; j < colors.length; ++j) {
                colors[j] = RewardsUtil.getRandomColor();
            }
            explosionData.m_128385_("Colors", colors);
            int[] fadeColors = new int[rand.nextInt(2) + 1];
            for (int j = 0; j < fadeColors.length; ++j) {
                fadeColors[j] = RewardsUtil.getRandomColor();
            }
            explosionData.m_128385_("FadeColors", fadeColors);
            explosionList.add((Object)explosionData);
        }
        data.m_128365_("Explosions", (Tag)explosionList);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Fireworks", (Tag)data);
        stack.m_41751_(nbt);
        return stack;
    }

    public static String getRandomOreDict() {
        return RewardsUtil.getRandomOreDict(new ArrayList<String>());
    }

    public static String getRandomOreDict(List<String> blacklist) {
        List<String> oredicts = RewardsUtil.getOreDicts().stream().filter(line -> !blacklist.contains(line)).toList();
        return oredicts.size() > 0 ? oredicts.get(rand.nextInt(oredicts.size())) : "ores/coal";
    }

    public static Fluid getRandomFluid(boolean onlySources) {
        Fluid fluid;
        do {
            fluid = (Fluid)RewardsUtil.randomRegistryEntry(ForgeRegistries.FLUIDS, Fluids.f_76193_);
        } while (onlySources && !fluid.m_7444_(fluid.m_76145_()));
        return fluid;
    }

    public static int getRandomColor() {
        return new Color(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256)).getRGB();
    }

    public static BlockState getRandomWool() {
        return wools[rand.nextInt(wools.length)].m_49966_();
    }

    public static boolean isPlayerOnline(Player player) {
        if (player == null) {
            return false;
        }
        for (ServerPlayer playerMP : player.f_19853_.m_7654_().m_6846_().m_11314_()) {
            if (!playerMP.m_20148_().equals(player.m_20148_())) continue;
            return true;
        }
        return false;
    }

    public static void executeCommand(ServerLevel level, Player player, Vec3i pos, String command) {
        RewardsUtil.executeCommand(level, player, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), command);
    }

    public static void executeCommand(ServerLevel level, Player player, Vec3 pos, String command) {
        MinecraftServer server = level.m_7654_();
        boolean rule = level.m_46469_().m_46207_(GameRules.f_46138_);
        ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46138_)).m_46246_(false, server);
        CommandSourceStack cs = new CommandSourceStack((CommandSource)player, pos, player.m_20155_(), level, 2, player.m_7755_().getString(), player.m_5446_(), server, (Entity)player);
        cs = cs.m_81324_();
        server.m_129892_().m_230957_(cs, command);
        ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46138_)).m_46246_(rule, server);
    }

    public static void setNearPlayersTitle(Level level, BlockPos pos, int range, GuiTextLocation type, Component message, int fadeInTime, int displayTime, int fadeOutTime) {
        for (int i = 0; i < level.m_6907_().size(); ++i) {
            Player entityplayer = (Player)level.m_6907_().get(i);
            double dist = Math.sqrt(Math.pow((double)pos.m_123341_() - entityplayer.m_20185_(), 2.0) + Math.pow((double)pos.m_123342_() - entityplayer.m_20186_(), 2.0) + Math.pow((double)pos.m_123343_() - entityplayer.m_20189_(), 2.0));
            if (!(dist <= (double)range)) continue;
            RewardsUtil.setPlayerTitle(entityplayer, type, message, fadeInTime, displayTime, fadeOutTime);
        }
    }

    public static void setAllPlayersTitle(Level level, GuiTextLocation type, Component message, int fadeInTime, int displayTime, int fadeOutTime) {
        for (int i = 0; i < level.m_6907_().size(); ++i) {
            RewardsUtil.setPlayerTitle((Player)level.m_6907_().get(i), type, message, fadeInTime, displayTime, fadeOutTime);
        }
    }

    public static void setPlayerTitle(Player player, GuiTextLocation type, Component message, int fadeInTime, int displayTime, int fadeOutTime) {
        if (player instanceof ServerPlayer) {
            ClientboundSetTitleTextPacket titlePacket = switch (type) {
                case GuiTextLocation.TITLE -> new ClientboundSetTitleTextPacket(message);
                case GuiTextLocation.SUBTITLE -> new ClientboundSetSubtitleTextPacket(message);
                default -> new ClientboundSetActionBarTextPacket(message);
            };
            ClientboundSetTitlesAnimationPacket timesPacket = new ClientboundSetTitlesAnimationPacket(fadeInTime, displayTime, fadeOutTime);
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)timesPacket);
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)titlePacket);
        }
    }

    public static String[] getHardcodedRewards() {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(RewardsUtil.class.getResourceAsStream("/data/chancecubes/rewards/rewards.txt")));
            ArrayList<String> files = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                files.add(line);
            }
            in.close();
            return files.toArray(new String[0]);
        }
        catch (Exception e) {
            CCubesCore.logger.error("CHANCE CUBES WAS UNABLE TO LOAD IN ITS DEFAULT REWARDS!!!!");
            CCubesCore.logger.error("REPORT TO MOD AUTHOR ASAP!!!");
            e.printStackTrace();
            return new String[0];
        }
    }

    public static JsonObject getRewardJson(String file) {
        BufferedReader in = new BufferedReader(new InputStreamReader(RewardsUtil.class.getResourceAsStream("/data/chancecubes/rewards/" + file)));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JsonParser.parseString((String)builder.toString()).getAsJsonObject();
    }
}

