/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageSource;
import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class MatchingReward
extends BaseCustomReward {
    private static final Block[] blocks = new Block[]{Blocks.f_50041_, Blocks.f_50042_, Blocks.f_50042_, Blocks.f_50096_, Blocks.f_50096_, Blocks.f_50097_, Blocks.f_50097_, Blocks.f_50099_, Blocks.f_50099_};

    public MatchingReward() {
        super("chancecubes:matching", 0);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, JsonObject settings) {
        int i;
        final RewardBlockCache cache = new RewardBlockCache((Level)level, pos, player.m_20097_());
        for (i = 0; i < 500; ++i) {
            int index1 = RewardsUtil.rand.nextInt(9);
            int index2 = RewardsUtil.rand.nextInt(9);
            Block temp = blocks[index1];
            MatchingReward.blocks[index1] = blocks[index2];
            MatchingReward.blocks[index2] = temp;
        }
        for (i = 0; i < blocks.length; ++i) {
            int x = i % 3 - 1;
            int z = i / 3 - 1;
            cache.cacheBlock(new BlockPos(x, -1, z), blocks[i].m_49966_());
        }
        RewardsUtil.sendMessageToPlayer(player, "Memorize these blocks!");
        int delay = super.getSettingAsInt(settings, "memDuration", 200, 60, 600);
        Scheduler.scheduleTask(new Task("Matching_Reward_Memorize_Delay", delay, 20){

            @Override
            public void callback() {
                for (int i = 0; i < blocks.length; ++i) {
                    int x = i % 3 - 1;
                    int z = i / 3 - 1;
                    level.m_46597_(pos.m_7918_(x, -1, z), Blocks.f_50058_.m_49966_());
                }
                MatchingReward.this.match(level, pos, player, blocks, cache);
            }

            @Override
            public void update() {
                this.showTimeLeft(player, GuiTextLocation.ACTION_BAR);
            }
        });
    }

    public void match(final ServerLevel level, final BlockPos pos, final Player player, final Block[] blocks, final RewardBlockCache cache) {
        RewardsUtil.sendMessageToPlayer(player, "Now break the matching blocks (in pairs with white last)! You have 45 seconds!");
        Scheduler.scheduleTask(new Task("Matching_Reward_Memerize_Delay", 900, 2){
            final boolean[] checked;
            int lastBroken;
            int matches;
            {
                super(name, delay, updateTick);
                this.checked = new boolean[9];
                this.lastBroken = -1;
                this.matches = 0;
            }

            @Override
            public void callback() {
                this.lose();
            }

            @Override
            public void update() {
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, GuiTextLocation.ACTION_BAR);
                }
                for (int i = 0; i < blocks.length; ++i) {
                    int x = i % 3 - 1;
                    int z = i / 3 - 1;
                    if (!level.m_8055_(pos.m_7918_(x, -1, z)).m_60795_() || this.checked[i]) continue;
                    this.checked[i] = true;
                    level.m_46597_(pos.m_7918_(x, -1, z), blocks[i].m_49966_());
                    if (this.lastBroken != -1) {
                        if (blocks[i] == blocks[this.lastBroken]) {
                            ++this.matches;
                            this.lastBroken = -1;
                            break;
                        }
                        this.lose();
                        Scheduler.removeTask(this);
                        break;
                    }
                    this.lastBroken = i;
                    if (this.matches != 4) continue;
                    this.win();
                    Scheduler.removeTask(this);
                    break;
                }
            }

            private void lose() {
                player.f_19853_.m_46511_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, Explosion.BlockInteraction.NONE);
                player.m_6469_((DamageSource)CCubesDamageSource.MATCHING_FAIL, Float.MAX_VALUE);
                this.reset();
            }

            private void win() {
                RewardsUtil.sendMessageToPlayer(player, "Good job! Have a cool little item!");
                player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1)));
                this.reset();
            }

            public void reset() {
                cache.restoreBlocks((Entity)player);
            }
        });
    }
}

