/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BossWitchReward
extends BossBaseReward {
    private final List<String> entities = Arrays.asList("creeper", "skeleton", "blaze", "enderman", "endermite", "zombie_pigman", "silverfish", "slime", "spider", "zombie");

    public BossWitchReward() {
        super("evil_witch");
    }

    @Override
    public LivingEntity initBoss(final ServerLevel level, BlockPos pos, final Player player, JsonObject settings, final BossBaseReward.BattleWrapper battleWrapper) {
        final Witch witch = (Witch)EntityType.f_20495_.m_20615_((Level)level);
        witch.m_6593_((Component)ComponentWrapper.string("Evil Witch"));
        ItemStack stack = new ItemStack((ItemLike)Items.f_42407_);
        stack.m_41663_(Enchantments.f_44968_, 5);
        witch.m_8061_(EquipmentSlot.HEAD, stack);
        witch.m_21409_(EquipmentSlot.HEAD, 0.0f);
        stack = new ItemStack((ItemLike)Items.f_42408_);
        stack.m_41663_(Enchantments.f_44968_, 5);
        witch.m_8061_(EquipmentSlot.CHEST, stack);
        witch.m_21409_(EquipmentSlot.CHEST, 0.0f);
        stack = new ItemStack((ItemLike)Items.f_42462_);
        stack.m_41663_(Enchantments.f_44968_, 5);
        witch.m_8061_(EquipmentSlot.LEGS, stack);
        witch.m_21409_(EquipmentSlot.LEGS, 0.0f);
        stack = new ItemStack((ItemLike)Items.f_42463_);
        stack.m_41663_(Enchantments.f_44968_, 5);
        witch.m_8061_(EquipmentSlot.FEET, stack);
        witch.m_21409_(EquipmentSlot.FEET, 0.0f);
        this.spawnMinoins(pos, level, battleWrapper);
        Scheduler.scheduleTask(new Task("witch_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!witch.m_6084_()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(15) == 4) {
                    BossWitchReward.this.spawnMinoins(witch.m_20097_(), level, battleWrapper);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    EntityWrapper.spawnLightning((Level)level, player.m_20097_());
                }
                if (RewardsUtil.rand.nextInt(5) == 4) {
                    BossWitchReward.this.throwPotion(witch, player.m_20097_(), level);
                }
            }
        });
        return witch;
    }

    private void throwPotion(Witch witch, BlockPos playerPos, ServerLevel level) {
        ThrownPotion pot = new ThrownPotion((Level)level, (LivingEntity)witch);
        MobEffectInstance potionEffect = RewardsUtil.getRandomPotionEffectInstance();
        pot.m_37446_(PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), List.of(potionEffect)));
        double d0 = (double)playerPos.m_123342_() + 0.5;
        double d1 = (double)playerPos.m_123341_() - witch.m_20185_();
        double d2 = d0 - pot.m_20186_();
        double d3 = (double)playerPos.m_123343_() - witch.m_20189_();
        float f = (float)(Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f);
        pot.m_6686_(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        level.m_7967_((Entity)pot);
    }

    private void spawnMinoins(BlockPos pos, ServerLevel level, BossBaseReward.BattleWrapper battleWrapper) {
        for (Direction facing : Direction.values()) {
            if (facing == Direction.UP || facing == Direction.DOWN) continue;
            try {
                Optional entType = EntityType.m_20632_((String)this.entities.get(RewardsUtil.rand.nextInt(this.entities.size())));
                Entity ent = entType.isPresent() ? ((EntityType)entType.get()).m_20615_((Level)level) : EntityType.f_20558_.m_20615_((Level)level);
                BlockPos adjPos = pos.m_5484_(facing, 1);
                ent.m_6027_((double)adjPos.m_123341_(), (double)adjPos.m_123342_(), (double)adjPos.m_123343_());
                level.m_7967_(ent);
                this.trackSubEntities(battleWrapper, ent);
            }
            catch (Exception e) {
                CCubesCore.logger.log(org.apache.logging.log4j.Level.ERROR, "Uh oh! Something went wrong and the minions could not be spawned! Please report this to the mod dev!");
                return;
            }
        }
    }

    @Override
    public void onBossFightEnd(ServerLevel world, BlockPos pos, Player player) {
    }
}

