/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.network;

import chanceCubes.CCubesCore;
import chanceCubes.containers.CreativePendantContainer;
import chanceCubes.items.ItemChanceCube;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.Level;

public class PacketCreativePendant {
    private final int chanceValue;

    public PacketCreativePendant(int chance) {
        this.chanceValue = chance;
    }

    public static void encode(PacketCreativePendant msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.chanceValue);
    }

    public static PacketCreativePendant decode(FriendlyByteBuf buf) {
        return new PacketCreativePendant(buf.readInt());
    }

    public static void handle(PacketCreativePendant msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            try {
                CreativePendantContainer container;
                ItemStack cCubes;
                AbstractContainerMenu c = player.f_36096_;
                if (c instanceof CreativePendantContainer && !(cCubes = (container = (CreativePendantContainer)c).getChanceCubesInPendant()).m_41619_() && cCubes.m_41720_() instanceof ItemChanceCube) {
                    ((ItemChanceCube)cCubes.m_41720_()).setChance(cCubes, msg.chanceValue);
                }
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Chance Cubes has failed to set the chance of a cube due to a packet failure! Please Inform Turkey of this!");
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

