/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.blueprint.client.RewardHandler;
import com.teamabnormals.blueprint.client.model.SlabfishHatModel;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.sonar.OnlineImageCache;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class SlabfishHatRenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public static OnlineImageCache REWARD_CACHE = new OnlineImageCache("blueprint", 1L, TimeUnit.DAYS);
    private final SlabfishHatModel model = new SlabfishHatModel(SlabfishHatModel.createBodyModel().m_171564_());

    public SlabfishHatRenderLayer(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
    }

    public void render(PoseStack stack, MultiBufferSource source, int packedLight, AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        RewardHandler.RewardProperties properties = RewardHandler.getRewardProperties();
        if (properties == null) {
            return;
        }
        RewardHandler.RewardProperties.SlabfishProperties slabfishProperties = properties.getSlabfishProperties();
        if (slabfishProperties == null) {
            return;
        }
        String defaultTypeUrl = slabfishProperties.getDefaultTypeUrl();
        IDataManager data = (IDataManager)entity;
        if (entity.m_20145_() || entity.m_5833_() || !RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.ENABLED) || defaultTypeUrl == null || !RewardHandler.REWARDS.containsKey(entity.m_20148_())) {
            return;
        }
        RewardHandler.RewardData reward = RewardHandler.REWARDS.get(entity.m_20148_());
        if (reward.getSlabfish() == null || reward.getTier() < 2) {
            return;
        }
        RewardHandler.RewardData.SlabfishData slabfish = reward.getSlabfish();
        ResourceLocation typeLocation = REWARD_CACHE.requestTexture(reward.getTier() >= 4 && slabfish.getTypeUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.TYPE) ? slabfish.getTypeUrl() : defaultTypeUrl).getNow(null);
        if (typeLocation == null) {
            return;
        }
        ResourceLocation sweaterLocation = reward.getTier() >= 3 && slabfish.getSweaterUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.SWEATER) ? (ResourceLocation)REWARD_CACHE.requestTexture(slabfish.getSweaterUrl()).getNow(null) : null;
        ResourceLocation backpackLocation = slabfish.getBackpackUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.BACKPACK) ? (ResourceLocation)REWARD_CACHE.requestTexture(slabfish.getBackpackUrl()).getNow(null) : null;
        ModelPart body = this.model.body;
        ModelPart backpack = this.model.backpack;
        body.m_104315_(((PlayerModel)this.m_117386_()).f_102808_);
        body.m_104301_(stack, source.m_6299_(slabfish.isTranslucent() ? RenderType.m_110473_((ResourceLocation)typeLocation) : RenderType.m_110452_((ResourceLocation)typeLocation)), packedLight, OverlayTexture.f_118083_);
        if (sweaterLocation != null) {
            body.m_104301_(stack, source.m_6299_(RenderType.m_110452_((ResourceLocation)sweaterLocation)), packedLight, OverlayTexture.f_118083_);
        }
        if (backpackLocation != null) {
            backpack.m_104315_(body);
            backpack.m_104301_(stack, source.m_6299_(RenderType.m_110452_((ResourceLocation)backpackLocation)), packedLight, OverlayTexture.f_118083_);
        }
    }
}

