/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.client.screen.TickBoxButton;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerLoadingScreen;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerSelectionList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.EditServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class PublicServersScreen
extends Screen {
    private static final Component JOIN_SERVER_TEXT = Component.m_237115_((String)"selectServer.select");
    private static final Component ADD_SERVER_TEXT = Component.m_237115_((String)"selectServer.add");
    private static final Component BACK_TEXT = CommonComponents.f_130660_;
    private static final Component REFRESH_TEXT = Component.m_237115_((String)"selectServer.refresh");
    private static final Component TITLE_TEXT = Component.m_237115_((String)"modules.public_server_list.title");
    private static final Component HOW_TO_TEXT = Component.m_237115_((String)"modules.public_server_list.how_to");
    private static final Component NAME_FILTER_TEXT = Component.m_237115_((String)"modules.public_server_list.filter.name");
    private static final Component PING_SORT_TEXT = Component.m_237115_((String)"modules.public_server_list.sort.ping");
    private static final Component PLAYER_COUNT_SORT_TEXT = Component.m_237115_((String)"modules.public_server_list.sort.player_count");
    private static final URI HOW_TO_URI = URI.create("https://www.bisecthosting.com/clients/index.php?rp=/knowledgebase/348/How-to-add-a-modpack-server-to-the-public-server-list.html");
    private final ServerStatusPinger pinger = new ServerStatusPinger();
    private PublicServerSelectionList serverSelectionList;
    private ServerListData servers;
    private Button addButton;
    private Button joinButton;
    private Button howTobutton;
    private EditBox searchBar;
    private TickBoxButton pingSort;
    private TickBoxButton playerCountSort;
    public static final float SPLIT = 0.4f;
    private List<Component> tooltip;
    private boolean openedLink;
    public final JoinMultiplayerScreen multiplayerScreen;
    private boolean hasInit;

    public PublicServersScreen(JoinMultiplayerScreen multiplayerScreen, List<ServerData> servers) {
        super(TITLE_TEXT);
        this.multiplayerScreen = multiplayerScreen;
        this.servers = new ServerListData(servers);
    }

    protected void m_7856_() {
        int splitWidth = (int)((float)this.f_96543_ * 0.4f);
        if (this.hasInit) {
            this.serverSelectionList.m_93437_(this.f_96543_ - splitWidth, this.f_96544_, 32, this.f_96544_ - 8);
            this.serverSelectionList.m_93507_(splitWidth);
        } else {
            this.hasInit = true;
            this.serverSelectionList = new PublicServerSelectionList(this, this.f_96541_, this.f_96543_ - splitWidth, this.f_96544_, 32, this.f_96544_ - 8, 36);
            this.serverSelectionList.m_93507_(splitWidth);
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        this.m_7787_((GuiEventListener)this.serverSelectionList);
        this.searchBar = new EditBox(this.getMinecraft().f_91062_, 10, 52, splitWidth - 20, 20, this.searchBar, (Component)Component.m_237113_((String)""));
        this.searchBar.m_94151_(this.serverSelectionList::setNameFilter);
        this.m_142416_((GuiEventListener)this.searchBar);
        this.pingSort = new TickBoxButton(splitWidth - 40, 90, this.pingSort, this.serverSelectionList::togglePingSort);
        this.m_142416_((GuiEventListener)this.pingSort);
        this.playerCountSort = new TickBoxButton(splitWidth - 40, 124, this.playerCountSort, this.serverSelectionList::togglePlayerCountSort);
        this.m_142416_((GuiEventListener)this.playerCountSort);
        int buttonWidth = Math.min(100, splitWidth / 2 - 4);
        this.m_142416_((GuiEventListener)new Button(splitWidth / 2 - buttonWidth - 2, this.f_96544_ - 28, buttonWidth, 20, REFRESH_TEXT, btn -> this.f_96541_.m_91152_((Screen)new PublicServerLoadingScreen((Screen)this.multiplayerScreen))));
        this.m_142416_((GuiEventListener)new Button(splitWidth / 2 + 2, this.f_96544_ - 28, buttonWidth, 20, BACK_TEXT, btn -> this.m_7379_()));
        this.howTobutton = (Button)this.m_142416_((GuiEventListener)new Button(splitWidth / 2 - buttonWidth - 2, this.f_96544_ - 76, buttonWidth * 2 + 4, 20, HOW_TO_TEXT, btn -> this.openHowToPage()));
        this.joinButton = (Button)this.m_142416_((GuiEventListener)new Button(splitWidth / 2 - buttonWidth - 2, this.f_96544_ - 52, buttonWidth, 20, JOIN_SERVER_TEXT, btn -> this.joinSelectedServer()));
        this.joinButton.f_93623_ = false;
        this.addButton = (Button)this.m_142416_((GuiEventListener)new Button(splitWidth / 2 + 2, this.f_96544_ - 52, buttonWidth, 20, ADD_SERVER_TEXT, btn -> this.addSelectedServer()));
        this.addButton.f_93623_ = false;
    }

    public void m_86600_() {
        super.m_86600_();
        this.pinger.m_105453_();
        this.searchBar.m_94120_();
        this.serverSelectionList.tick();
        if (this.openedLink) {
            this.howTobutton.m_5755_(false);
            this.openedLink = false;
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.f_96543_ * 0.4f);
        this.tooltip = null;
        this.m_7333_(matrix);
        this.serverSelectionList.m_6305_(matrix, mouseX, mouseY, delta);
        super.m_6305_(matrix, mouseX, mouseY, delta);
        Objects.requireNonNull(this.f_96547_);
        float fontHeight = 9.0f;
        PublicServersScreen.m_93215_((PoseStack)matrix, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)-1);
        if (this.tooltip != null) {
            this.m_96597_(matrix, this.tooltip, mouseX, mouseY);
        }
        PublicServersScreen.m_93215_((PoseStack)matrix, (Font)this.f_96547_, (Component)NAME_FILTER_TEXT, (int)(splitWidth / 2), (int)32, (int)-1);
        PublicServersScreen.m_93243_((PoseStack)matrix, (Font)this.f_96547_, (Component)PING_SORT_TEXT, (int)20, (int)(90 + (int)((20.0f - fontHeight) / 2.0f)), (int)-1);
        PublicServersScreen.m_93243_((PoseStack)matrix, (Font)this.f_96547_, (Component)PLAYER_COUNT_SORT_TEXT, (int)20, (int)(124 + (int)((20.0f - fontHeight) / 2.0f)), (int)-1);
    }

    public void joinSelectedServer() {
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.m_93511_();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            PublicServerSelectionList.ServerEntry serverEntry = (PublicServerSelectionList.ServerEntry)entry;
            this.join(serverEntry);
        }
    }

    public void join(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setLastJoined(entry);
        this.join(entry.getServerData());
    }

    private void join(ServerData server) {
        ConnectScreen.m_169267_((Screen)this, (Minecraft)this.f_96541_, (ServerAddress)ServerAddress.m_171864_((String)server.f_105363_), (ServerData)server);
    }

    public void addSelectedServer() {
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.m_93511_();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            PublicServerSelectionList.ServerEntry serverEntry = (PublicServerSelectionList.ServerEntry)entry;
            ServerData data = serverEntry.getServerData();
            this.multiplayerScreen.f_99682_ = new ServerData(data.f_105362_, data.f_105363_, false);
            this.f_96541_.m_91152_((Screen)new EditServerScreen((Screen)this, add -> this.multiplayerScreen.m_99721_(add), this.multiplayerScreen.f_99682_));
        }
    }

    public void openHowToPage() {
        ModRef.LOGGER.info("Opening knowledgebase " + HOW_TO_URI);
        Util.m_137581_().m_137648_(HOW_TO_URI);
        this.openedLink = true;
    }

    public void setSelected(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setSelected(entry);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        this.joinButton.f_93623_ = false;
        this.addButton.f_93623_ = false;
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.m_93511_();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            this.joinButton.f_93623_ = true;
            this.addButton.f_93623_ = true;
        }
    }

    public void m_7861_() {
        this.pinger.m_105465_();
        this.serverSelectionList.stopPingingServer();
    }

    public void m_7379_() {
        if (!this.searchBar.m_94155_().isEmpty()) {
            this.searchBar.m_94144_("");
        } else {
            this.f_96541_.m_91152_((Screen)this.multiplayerScreen);
        }
    }

    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public ServerStatusPinger getPinger() {
        return this.pinger;
    }

    public ServerListData getServers() {
        return this.servers;
    }
}

