/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Recipes.Ingredients;

import com.google.gson.JsonObject;

public class EnergyIngredient {
    private static final String KEY_ENERGY = "energy";
    private static final int RFPT_DEFAULT = 0;
    private int energyNeeded;

    public EnergyIngredient(int rf) {
        this.setEnergyNeeded(rf);
    }

    public EnergyIngredient(JsonObject recipeJson) {
        this.parseData(recipeJson);
    }

    private void parseData(JsonObject recipeJson) {
        if (!recipeJson.has(KEY_ENERGY)) {
            this.setEnergyNeeded(0);
        } else if (recipeJson.get(KEY_ENERGY).isJsonObject()) {
            JsonObject energyJson = recipeJson.get(KEY_ENERGY).getAsJsonObject();
            this.setEnergyNeeded(energyJson.get("energyValue").getAsInt());
        } else {
            this.setEnergyNeeded(recipeJson.get(KEY_ENERGY).getAsInt());
        }
    }

    private void setEnergyNeeded(int rf) {
        this.energyNeeded = Math.max(0, rf);
    }

    public int getEnergyNeeded() {
        return this.energyNeeded;
    }
}

