/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.WorkCards;

import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlock;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.ISelectableArea;
import com.mowmaster.pedestals.Items.ISelectablePoints;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.IPedestalWorkCard;
import com.mowmaster.pedestals.PedestalUtils.MoveToMowLibUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class WorkCardBase
extends Item
implements IPedestalWorkCard {
    public WorkCardBase(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public int getWorkCardType() {
        return -1;
    }

    public static void saveStringToNBT(ItemStack upgrade, String nbtTag, String string) {
        CompoundTag compound = upgrade.m_41784_();
        compound.m_128359_("pedestals" + nbtTag, string);
    }

    public static boolean addBlockPosToList(ItemStack upgrade, BlockPos posOfBlock) {
        List<BlockPos> currentList = WorkCardBase.readBlockPosListFromNBT(upgrade);
        if (currentList.contains(posOfBlock)) {
            currentList.remove(posOfBlock);
            WorkCardBase.saveBlockPosListToNBT(upgrade, currentList);
            return false;
        }
        currentList.add(posOfBlock);
        WorkCardBase.saveBlockPosListToNBT(upgrade, currentList);
        return true;
    }

    public static void saveBlockPosListToNBT(ItemStack upgrade, List<BlockPos> posListToSave) {
        CompoundTag compound = upgrade.m_41784_();
        ArrayList<Integer> storedX = new ArrayList<Integer>();
        ArrayList<Integer> storedY = new ArrayList<Integer>();
        ArrayList<Integer> storedZ = new ArrayList<Integer>();
        for (BlockPos blockPos : posListToSave) {
            storedX.add(blockPos.m_123341_());
            storedY.add(blockPos.m_123342_());
            storedZ.add(blockPos.m_123343_());
        }
        compound.m_128408_("pedestals_intArrayXPos", storedX);
        compound.m_128408_("pedestals_intArrayYPos", storedY);
        compound.m_128408_("pedestals_intArrayZPos", storedZ);
    }

    public static List<BlockPos> readBlockPosListFromNBT(ItemStack upgrade) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        if (upgrade.m_41782_()) {
            String tagX = "pedestals_intArrayXPos";
            String tagY = "pedestals_intArrayYPos";
            String tagZ = "pedestals_intArrayZPos";
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tagX) && upgrade.m_41783_().m_128441_(tagY) && upgrade.m_41783_().m_128441_(tagZ)) {
                int[] storedIX = getCompound.m_128465_(tagX);
                int[] storedIY = getCompound.m_128465_(tagY);
                int[] storedIZ = getCompound.m_128465_(tagZ);
                for (int i = 0; i < storedIX.length; ++i) {
                    BlockPos gotPos = new BlockPos(storedIX[i], storedIY[i], storedIZ[i]);
                    posList.add(gotPos);
                }
            }
        }
        return posList;
    }

    public static void saveBlockPosToNBT(ItemStack upgrade, int num, BlockPos posToSave) {
        CompoundTag compound = upgrade.m_41784_();
        ArrayList<Integer> listed = new ArrayList<Integer>();
        listed.add(posToSave.m_123341_());
        listed.add(posToSave.m_123342_());
        listed.add(posToSave.m_123343_());
        compound.m_128408_("pedestals_upgrade_blockpos_" + num, listed);
    }

    public static BlockPos readBlockPosFromNBT(ItemStack upgrade, int num) {
        if (upgrade.m_41782_()) {
            int[] listed;
            String tag = "pedestals_upgrade_blockpos_" + num;
            CompoundTag compound = upgrade.m_41783_();
            if (compound.m_128441_(tag) && (listed = compound.m_128465_(tag)).length >= 3) {
                return new BlockPos(listed[0], listed[1], listed[2]);
            }
        }
        return BlockPos.f_121853_;
    }

    public boolean hasOneBlockPos(ItemStack stack) {
        return !WorkCardBase.readBlockPosFromNBT(stack, 1).equals((Object)BlockPos.f_121853_) || !WorkCardBase.readBlockPosFromNBT(stack, 2).equals((Object)BlockPos.f_121853_);
    }

    public boolean hasTwoPointsSelected(ItemStack stack) {
        return !WorkCardBase.readBlockPosFromNBT(stack, 1).equals((Object)BlockPos.f_121853_) && !WorkCardBase.readBlockPosFromNBT(stack, 2).equals((Object)BlockPos.f_121853_);
    }

    public boolean isSelectionInRange(BasePedestalBlockEntity pedestal, BlockPos pos) {
        int range = (Integer)PedestalConfig.COMMON.upgrades_baseSelectionRange.get();
        Item item = pedestal.getCoinOnPedestal().m_41720_();
        if (item instanceof ItemUpgradeBase) {
            ItemUpgradeBase upgrade = (ItemUpgradeBase)item;
            range += upgrade.getRangeIncrease(pedestal.getCoinOnPedestal());
        }
        return MoveToMowLibUtils.arePositionsInRange(pos, pedestal.getPos(), range);
    }

    public boolean selectedAreaWithinRange(BasePedestalBlockEntity pedestal) {
        return this.isSelectionInRange(pedestal, WorkCardBase.readBlockPosFromNBT(pedestal.getWorkCardInPedestal(), 1)) && this.isSelectionInRange(pedestal, WorkCardBase.readBlockPosFromNBT(pedestal.getWorkCardInPedestal(), 2));
    }

    public boolean selectedPointWithinRange(BasePedestalBlockEntity pedestal, BlockPos posPoint) {
        return this.isSelectionInRange(pedestal, posPoint);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        WorkCardBase.saveBlockPosToNBT(stack, 10, context.m_8083_());
        WorkCardBase.saveStringToNBT(stack, "_string_last_clicked_direction", context.m_43719_().toString());
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        Item item;
        ItemStack itemInHand = player.m_21120_(hand);
        HitResult result = player.m_19907_(5.0, player.m_20192_(), false);
        BlockPos atLocation = WorkCardBase.readBlockPosFromNBT(itemInHand, 10);
        if (hand.equals((Object)InteractionHand.MAIN_HAND) && (item = itemInHand.m_41720_()) instanceof WorkCardBase) {
            WorkCardBase baseCard = (WorkCardBase)item;
            if (itemInHand.m_41720_() instanceof ISelectablePoints) {
                if (result.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                    if (baseCard.getWorkCardType() == 3 && !(level.m_8055_(atLocation).m_60734_() instanceof BasePedestalBlock)) {
                        return InteractionResultHolder.m_19100_((Object)itemInHand);
                    }
                    boolean added = WorkCardBase.addBlockPosToList(itemInHand, atLocation);
                    MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)(added ? ChatFormatting.WHITE : ChatFormatting.BLACK), (String)(added ? "pedestals.upgrade_blockpos_added" : "pedestals.upgrade_blockpos_removed"));
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)player.m_20097_(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)atLocation.m_123341_(), (double)atLocation.m_123342_() + 1.0, (double)atLocation.m_123343_(), new int[]{0, added ? 200 : 0, 0}));
                } else if (result.m_6662_().equals((Object)HitResult.Type.MISS) && WorkCardBase.readBlockPosListFromNBT(itemInHand).size() > 0) {
                    itemInHand.m_41751_(new CompoundTag());
                    MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_clear");
                }
            } else if (itemInHand.m_41720_() instanceof ISelectableArea) {
                if (result.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                    if (!this.hasOneBlockPos(itemInHand)) {
                        WorkCardBase.saveBlockPosToNBT(itemInHand, 1, atLocation);
                        player.m_21008_(hand, itemInHand);
                        MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_first");
                    } else if (!this.hasTwoPointsSelected(itemInHand)) {
                        WorkCardBase.saveBlockPosToNBT(itemInHand, 2, atLocation);
                        player.m_21008_(hand, itemInHand);
                        MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_second");
                    }
                } else if (result.m_6662_().equals((Object)HitResult.Type.MISS) && this.hasOneBlockPos(itemInHand)) {
                    itemInHand.m_41751_(new CompoundTag());
                    MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_clear");
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemInHand);
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        List<BlockPos> getList;
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        if (Screen.m_96638_() && Screen.m_96639_()) {
            p_41423_.add((Component)Component.m_237113_((String)""));
        }
        if (p_41421_.m_41720_() instanceof WorkCardBase && p_41421_.m_41720_() instanceof ISelectableArea && this.hasOneBlockPos(p_41421_)) {
            if (!Screen.m_96638_()) {
                MutableComponent base = Component.m_237115_((String)"pedestals.workcard_description_shift");
                base.m_130940_(ChatFormatting.WHITE);
                p_41423_.add((Component)base);
            } else {
                MutableComponent posTitle = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockpos_title");
                posTitle.m_130940_(ChatFormatting.GOLD);
                p_41423_.add((Component)posTitle);
                MutableComponent separator = Component.m_237115_((String)"pedestals.tooltip_separator");
                p_41423_.add((Component)separator);
                MutableComponent posOne = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockpos_one");
                BlockPos blockPosOne = WorkCardBase.readBlockPosFromNBT(p_41421_, 1);
                MutableComponent posOnePos = Component.m_237113_((String)(blockPosOne.m_123341_() + "x " + blockPosOne.m_123342_() + "y " + blockPosOne.m_123343_() + "z"));
                posOnePos.m_130940_(ChatFormatting.GRAY);
                posOne.m_7220_((Component)Component.m_237115_((String)"pedestals.upgrade_tooltip_separator"));
                posOne.m_7220_((Component)posOnePos);
                p_41423_.add((Component)posOne);
                MutableComponent posTwo = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockpos_two");
                BlockPos blockPosTwo = WorkCardBase.readBlockPosFromNBT(p_41421_, 2);
                MutableComponent posTwoPos = Component.m_237113_((String)(blockPosTwo.m_123341_() + "x " + blockPosTwo.m_123342_() + "y " + blockPosTwo.m_123343_() + "z"));
                posTwoPos.m_130940_(ChatFormatting.GRAY);
                posTwo.m_7220_((Component)Component.m_237115_((String)"pedestals.upgrade_tooltip_separator"));
                posTwo.m_7220_((Component)posTwoPos);
                p_41423_.add((Component)posTwo);
            }
        }
        if (p_41421_.m_41720_() instanceof WorkCardBase && p_41421_.m_41720_() instanceof ISelectablePoints && !this.hasTwoPointsSelected(p_41421_) && (getList = WorkCardBase.readBlockPosListFromNBT(p_41421_)).size() > 0) {
            if (!Screen.m_96638_()) {
                MutableComponent base = Component.m_237115_((String)"pedestals.workcard_description_shift");
                base.m_130940_(ChatFormatting.WHITE);
                p_41423_.add((Component)base);
            } else {
                MutableComponent posTitle = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockpos_title");
                posTitle.m_130940_(ChatFormatting.GOLD);
                p_41423_.add((Component)posTitle);
                MutableComponent separator = Component.m_237115_((String)"pedestals.tooltip_separator");
                p_41423_.add((Component)separator);
                for (BlockPos pos : getList) {
                    MutableComponent posOnePos = Component.m_237113_((String)(pos.m_123341_() + "x " + pos.m_123342_() + "y " + pos.m_123343_() + "z"));
                    posOnePos.m_130940_(ChatFormatting.GRAY);
                    p_41423_.add((Component)posOnePos);
                }
            }
        }
    }
}

