/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.PedestalUtils.MoveToMowLibUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class ItemUpgradeAbstractCookingBase<T extends AbstractCookingRecipe>
extends ItemUpgradeBase {
    private final RecipeType<T> recipeType;

    public ItemUpgradeAbstractCookingBase(Item.Properties p_41383_, RecipeType<T> rType) {
        super(p_41383_);
        this.recipeType = rType;
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getMaxSpeed(ItemStack upgradeItemStack) {
        return 200;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return this.baseEnergyCost();
    }

    public abstract int baseEnergyCost();

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        ArrayList<String> messages = new ArrayList<String>();
        if (pedestal.getItemInPedestal().m_41619_() && this.baseEnergyCost() > 0) {
            boolean hasItem = MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)pedestal.getCoinOnPedestal().m_41784_(), (String)"hasitem");
            if (pedestal.getStoredEnergy() < this.baseEnergyCost() && hasItem) {
                messages.add(ChatFormatting.RED + "Needs Energy");
            }
        }
        return messages;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        MoveToMowLibUtils.resetCachedAbstractCooking("pedestals", coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"hasitem");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"input");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"output");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"cooktime");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"xpamount");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"_numdelay");
    }

    private void updateHasItemNBT(BasePedestalBlockEntity pedestal, boolean state) {
        CompoundTag tag = pedestal.getCoinOnPedestal().m_41784_();
        if (MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)tag, (String)"hasitem") != state) {
            MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)tag, (boolean)state, (String)"hasitem");
            pedestal.update();
        }
    }

    @Override
    public void updateAction(Level level, BasePedestalBlockEntity pedestal) {
        BlockPos pedestalPos = pedestal.getPos();
        BlockPos inventoryPos = this.getPosOfBlockBelow(level, pedestalPos, 1);
        if (level.m_7702_(inventoryPos) instanceof BasePedestalBlockEntity) {
            this.updateHasItemNBT(pedestal, false);
            return;
        }
        MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)inventoryPos, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true).map(handler -> ItemUpgradeAbstractCookingBase.getFirstSlotWithNonMachineFilteredItems(pedestal, handler).map(slot -> {
            ItemStack inputItem;
            ItemStack upgrade = pedestal.getCoinOnPedestal();
            ItemStack cookResult = MoveToMowLibUtils.getAbstractCookingResult("pedestals", level, upgrade, inputItem = handler.getStackInSlot(slot.intValue()), this.recipeType);
            if (!cookResult.m_41619_()) {
                int startingElapsedCookTime;
                int newElapsedCookTime = startingElapsedCookTime = MoveToMowLibUtils.getCookTimeElapsed("pedestals", upgrade);
                int requiredCookTime = MoveToMowLibUtils.getCookTimeRequired("pedestals", upgrade);
                boolean spawnParticles = false;
                int particleRed = 0;
                int particleGreen = 0;
                int particleBlue = 0;
                if (newElapsedCookTime < requiredCookTime) {
                    int timeToElapseBasedOnSpeed = Math.max(1, this.getSpeedTicksReduced(upgrade));
                    int timeToElapseBasedOnAvailableEnergy = pedestal.getStoredEnergy() / this.baseEnergyCost();
                    int timeToElapse = Math.min(timeToElapseBasedOnSpeed, timeToElapseBasedOnAvailableEnergy);
                    int energyCost = this.baseEnergyCost() * timeToElapse;
                    if (energyCost > 0 && pedestal.removeEnergy(energyCost, true) == energyCost) {
                        pedestal.removeEnergy(energyCost, false);
                        newElapsedCookTime += timeToElapse;
                        spawnParticles = true;
                    }
                }
                if (newElapsedCookTime >= requiredCookTime) {
                    int amountAvailableToCook = inputItem.m_41613_();
                    int amountCompletedCooks = newElapsedCookTime / requiredCookTime;
                    int amountToAdd = Math.min(amountAvailableToCook, amountCompletedCooks);
                    cookResult.m_41764_(amountToAdd);
                    ItemStack leftover = pedestal.addItemStack(cookResult, false);
                    int amountAdded = amountToAdd - leftover.m_41613_();
                    handler.extractItem(slot.intValue(), amountAdded, false);
                    pedestal.addExperience(MoveToMowLibUtils.getXpGainFromCachedRecipe("pedestals", upgrade) * amountAdded, false);
                    newElapsedCookTime -= requiredCookTime * amountAdded;
                    if (amountAdded > 0) {
                        particleRed = 255;
                        particleGreen = 150;
                        spawnParticles = true;
                    }
                }
                if (newElapsedCookTime != startingElapsedCookTime) {
                    MoveToMowLibUtils.setCookTimeElapsed("pedestals", upgrade, newElapsedCookTime);
                }
                if (spawnParticles && pedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_() + 0.75, (double)pedestalPos.m_123343_(), new int[]{particleRed, particleGreen, particleBlue}));
                }
            }
            return slot;
        })).ifPresentOrElse(maybeSlot -> this.updateHasItemNBT(pedestal, maybeSlot.isPresent()), () -> this.updateHasItemNBT(pedestal, false));
    }
}

