/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.MechanicalOnlyStorage;

import com.mowmaster.mowlib.Items.BaseEnergyDropItem;
import com.mowmaster.mowlib.MowLibUtils.MowLibTooltipUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibXpUtils;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.IBulkItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BaseXpBulkStorageItem
extends BaseEnergyDropItem
implements IBulkItem {
    private int counter = 0;

    public BaseXpBulkStorageItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    private int getDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            return BaseXpBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        this.setDischargeCounter(stack);
        return 0;
    }

    private void increaseDischargeCounter(ItemStack stack) {
        int current = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            current = BaseXpBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        BaseXpBulkStorageItem.writeIntegerToNBT("pedestals", tag, current + 1, "_dischargeCounter");
    }

    private void setDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        BaseXpBulkStorageItem.writeIntegerToNBT("pedestals", tag, 0, "_dischargeCounter");
    }

    public static CompoundTag writeIntegerToNBT(String ModID, @Nullable CompoundTag inputNBT, int input, String intName) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        compound.m_128405_(ModID + intName, input);
        return compound;
    }

    public static int readIntegerFromNBT(String ModID, CompoundTag inputNBT, String intName) {
        if (inputNBT.m_128441_(ModID + intName)) {
            return inputNBT.m_128451_(ModID + intName);
        }
        return 0;
    }

    public static int getItemColor() {
        return 5373775;
    }

    public int getMaxAllowedStorage() {
        return MowLibXpUtils.getExpCountByLevel((int)((Integer)PedestalConfig.COMMON.pedestal_baseXpStorage.get())) + MowLibXpUtils.getExpCountByLevel((int)((Integer)PedestalConfig.COMMON.augment_t4StorageXp.get())) * (Integer)PedestalConfig.COMMON.augment_t4StorageInsertSize.get();
    }

    public void setXp(ItemStack stack, int amount) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        CompoundTag returnerTag = BaseXpBulkStorageItem.writeIntegerToNBT("pedestals", tag, amount, "_bulkxpstorage");
        stack.m_41751_(returnerTag);
    }

    public int getXp(ItemStack stack) {
        int currentStored = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_bulkxpstorage")) {
            currentStored = BaseXpBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_bulkxpstorage");
        }
        return currentStored;
    }

    public void addXp(ItemStack stack, int added) {
        int difference;
        int currentStored = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_bulkxpstorage")) {
            currentStored = BaseXpBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_bulkxpstorage");
        }
        CompoundTag returnerTag = BaseXpBulkStorageItem.writeIntegerToNBT("pedestals", tag, (difference = currentStored + added) > this.getMaxAllowedStorage() ? this.getMaxAllowedStorage() : difference, "_bulkxpstorage");
        stack.m_41751_(returnerTag);
    }

    public void removeXp(ItemStack stack, int removed) {
        int difference;
        int currentStored = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_bulkxpstorage")) {
            currentStored = BaseXpBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_bulkxpstorage");
        }
        CompoundTag returnerTag = BaseXpBulkStorageItem.writeIntegerToNBT("pedestals", tag, (difference = currentStored - removed) > 0 ? difference : 0, "_bulkxpstorage");
        stack.m_41751_(returnerTag);
    }

    public int getItemVariant(ItemStack stack) {
        if (this.getXp(stack) > 0) {
            double renderDevider = 100.0 * (double)(this.getXp(stack) / this.getMaxAllowedStorage());
            if (renderDevider <= 25.0) {
                return 0;
            }
            if (renderDevider <= 50.0) {
                return 1;
            }
            if (renderDevider <= 75.0) {
                return 2;
            }
            if (renderDevider >= 100.0) {
                return 3;
            }
        }
        return 0;
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (!p_41405_.m_5776_()) {
            Player player;
            boolean survival = true;
            if (p_41406_ instanceof Player && (player = (Player)p_41406_).m_7500_()) {
                survival = false;
            }
            if (survival && ((Boolean)PedestalConfig.COMMON.bulkstorage_xpDischarge_toggle.get()).booleanValue()) {
                int stored = this.getXp(p_41404_);
                if (stored > 0) {
                    ++this.counter;
                    if (this.counter >= 20) {
                        this.increaseDischargeCounter(p_41404_);
                        this.counter = 0;
                    }
                }
                if (this.getDischargeCounter(p_41404_) >= (Integer)PedestalConfig.COMMON.bulkstorage_xpDischarge.get()) {
                    this.removeXp(p_41405_, p_41406_.m_20097_(), p_41404_);
                    p_41404_.m_41774_(1);
                }
            }
        }
    }

    public void removeXp(Level worldIn, BlockPos pos, ItemStack stack) {
        int xpStored = this.getXp(stack);
        if (xpStored > 0) {
            ExperienceOrb xpEntity = new ExperienceOrb(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), xpStored);
            xpEntity.m_6001_(0.0, 0.0, 0.0);
            worldIn.m_7967_((Entity)xpEntity);
        }
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        int charge;
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        int stored = this.getXp(p_41421_);
        if (stored > 0) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_xp"), (ChatFormatting)ChatFormatting.GOLD);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)("" + stored)), (ChatFormatting)ChatFormatting.WHITE);
        }
        if ((charge = this.getDischargeCounter(p_41421_)) > 0) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_xp_discharge"), (ChatFormatting)ChatFormatting.RED);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)(charge + "/" + PedestalConfig.COMMON.bulkstorage_xpDischarge.get())), (ChatFormatting)ChatFormatting.WHITE);
        }
    }
}

