/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.network.shared;

import com.cyanogen.experienceobelisk.network.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class UpdateInventory {
    public static CompoundTag container;
    public static CompoundTag inventory;

    public UpdateInventory(CompoundTag container, CompoundTag inventory) {
        UpdateInventory.container = container;
        UpdateInventory.inventory = inventory;
    }

    public UpdateInventory(FriendlyByteBuf buffer) {
        container = buffer.m_130260_();
        inventory = buffer.m_130260_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(container);
        buffer.m_130079_(inventory);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            assert (sender != null);
            ListTag inventoryList = (ListTag)inventory.m_128423_("Inventory");
            ListTag containerList = container.m_128437_("Container", 10);
            sender.m_150109_().m_36035_(inventoryList);
            for (Slot slot : sender.f_36096_.f_38839_) {
                CompoundTag tag = containerList.m_128728_(slot.f_40219_);
                slot.m_5852_(ItemStack.m_41712_((CompoundTag)tag));
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }

    public static void updateInventoryFromClient(Player player) {
        ListTag inventoryList = new ListTag();
        player.m_150109_().m_36026_(inventoryList);
        ListTag containerList = new ListTag();
        for (Slot slot : player.f_36096_.f_38839_) {
            CompoundTag tag = new CompoundTag();
            slot.m_7993_().m_41739_(tag);
            containerList.add(slot.f_40219_, (Tag)tag);
        }
        CompoundTag inventoryTag = new CompoundTag();
        inventoryTag.m_128365_("Inventory", (Tag)inventoryList);
        CompoundTag containerTag = new CompoundTag();
        containerTag.m_128365_("Container", (Tag)containerList);
        PacketHandler.INSTANCE.sendToServer((Object)new UpdateInventory(containerTag, inventoryTag));
    }
}

