/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.gui;

import com.cyanogen.experienceobelisk.block_entities.PrecisionDispellerEntity;
import com.cyanogen.experienceobelisk.gui.PrecisionDispellerMenu;
import com.cyanogen.experienceobelisk.network.PacketHandler;
import com.cyanogen.experienceobelisk.network.precision_dispeller.UpdateSlot;
import com.cyanogen.experienceobelisk.utils.ExperienceUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;

public class PrecisionDispellerScreen
extends AbstractContainerScreen<PrecisionDispellerMenu> {
    private final ResourceLocation texture = new ResourceLocation("experienceobelisk:textures/gui/screens/precision_dispeller.png");
    private final Component title = Component.m_237115_((String)"title.experienceobelisk.precision_dispeller");
    private final Component inventoryTitle = Component.m_237115_((String)"title.experienceobelisk.precision_dispeller.inventory");
    public PrecisionDispellerEntity dispeller;
    public ArrayList<SelectablePanel> selectablePanels = new ArrayList();
    public int selectedIndex = -1;
    int scrollButtonPos = 18;
    int offset = 0;
    boolean scrollClicked = false;
    boolean scrollEnabled = false;
    int clickedDelta = -1;

    public PrecisionDispellerScreen(PrecisionDispellerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.dispeller = menu.dispellerClient;
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, this.title, (float)this.f_97728_, (float)this.f_97729_, 0xFFFFFF);
        this.f_96547_.m_92889_(poseStack, this.inventoryTitle, (float)this.f_97730_, (float)this.f_97731_, 0xFFFFFF);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.selectablePanels.clear();
        this.m_7333_(poseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, 176, 166);
        ItemStack inputStack = ((PrecisionDispellerMenu)this.f_97732_).container.m_8020_(0);
        Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)inputStack);
        boolean bl = this.scrollEnabled = enchantmentMap.size() > 3;
        if ((inputStack.m_41793_() || inputStack.m_150930_(Items.f_42690_)) && this.scrollEnabled) {
            PrecisionDispellerScreen.m_93133_((PoseStack)poseStack, (int)(x + 153), (int)(y + this.scrollButtonPos), (float)177.0f, (float)0.0f, (int)9, (int)13, (int)256, (int)256);
        } else {
            this.scrollButtonPos = 18;
            PrecisionDispellerScreen.m_93133_((PoseStack)poseStack, (int)(x + 153), (int)(y + 18), (float)187.0f, (float)0.0f, (int)9, (int)13, (int)256, (int)256);
        }
        if (inputStack.m_41793_() || inputStack.m_150930_(Items.f_42690_)) {
            int index = 0;
            for (Map.Entry entry : enchantmentMap.entrySet()) {
                int n = enchantmentMap.size() - 3;
                int b = this.scrollButtonPos - 18;
                if (n > 0) {
                    this.offset = -b * 17 * n / 38;
                }
                int xpos = x + 49;
                int ypos = y + 18 + 17 * index + this.offset;
                boolean visibility = ypos > y + 1 && ypos < y + 69;
                this.selectablePanels.add(new SelectablePanel(xpos, ypos, (Enchantment)entry.getKey(), (Integer)entry.getValue(), Status.UNHOVERED, visibility));
                ++index;
            }
            for (SelectablePanel panel : this.selectablePanels) {
                if (this.selectablePanels.indexOf(panel) == this.selectedIndex) {
                    panel.status = Status.SELECTED;
                } else if (panel.isHovered(mouseX, mouseY)) {
                    panel.status = Status.HOVERED;
                }
                if (!panel.isVisible) continue;
                panel.renderPanel(poseStack);
            }
            for (SelectablePanel panel : this.selectablePanels) {
                if (!panel.isVisible) continue;
                panel.renderText(poseStack, this.f_96547_);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
            PrecisionDispellerScreen.m_93133_((PoseStack)poseStack, (int)(x + 49), (int)(y + 1), (float)49.0f, (float)1.0f, (int)102, (int)17, (int)256, (int)256);
            PrecisionDispellerScreen.m_93133_((PoseStack)poseStack, (int)(x + 49), (int)(y + 69), (float)49.0f, (float)69.0f, (int)102, (int)17, (int)256, (int)256);
        } else {
            this.selectedIndex = -1;
            this.offset = 0;
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7025_(PoseStack poseStack, int x, int y) {
        long playerXP = ExperienceUtils.levelsToXP(((PrecisionDispellerMenu)this.f_97732_).player.f_36078_) + Math.round(((PrecisionDispellerMenu)this.f_97732_).player.f_36080_ * (float)((PrecisionDispellerMenu)this.f_97732_).player.m_36323_());
        for (SelectablePanel panel : this.selectablePanels) {
            if (!panel.isHovered(x, y) || !panel.isVisible || panel.status.equals((Object)Status.SELECTED)) continue;
            ArrayList<MutableComponent> tooltipList = new ArrayList<MutableComponent>();
            tooltipList.add(Component.m_237113_((String)panel.getFullName()));
            if (panel.enchantment.m_6589_()) {
                tooltipList.add(Component.m_237115_((String)"tooltip.experienceobelisk.precision_dispeller.curse"));
                if (!this.dispeller.obeliskStillExists && playerXP < 1395L) {
                    tooltipList.add(Component.m_237115_((String)"tooltip.experienceobelisk.precision_dispeller.insufficient_xp"));
                } else if (this.dispeller.obeliskStillExists && (long)this.dispeller.obeliskPoints + playerXP < 1395L) {
                    tooltipList.add(Component.m_237115_((String)"tooltip.experienceobelisk.precision_dispeller.insufficient_xp"));
                }
            } else {
                int points = panel.enchantment.m_6183_(panel.level);
                int levels = ExperienceUtils.xpToLevels(points);
                MutableComponent pts = Component.m_237115_((String)String.valueOf(points)).m_130940_(ChatFormatting.GREEN);
                MutableComponent lvls = Component.m_237115_((String)String.valueOf(levels)).m_130940_(ChatFormatting.GREEN);
                tooltipList.add(Component.m_237110_((String)"tooltip.experienceobelisk.precision_dispeller.enchantment", (Object[])new Object[]{pts, lvls}));
            }
            this.m_169388_(poseStack, tooltipList, Optional.empty(), x, y);
        }
        super.m_7025_(poseStack, x, y);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (mouseX >= (double)(x + 48) && mouseX <= (double)(x + 162) && mouseY >= (double)(y + 17) && mouseY <= (double)(y + 69) && this.scrollEnabled) {
            this.scrollButtonPos -= 4 * (int)delta;
        }
        if (this.scrollButtonPos > 56) {
            this.scrollButtonPos = 56;
        } else if (this.scrollButtonPos < 18) {
            this.scrollButtonPos = 18;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollClicked = false;
        this.clickedDelta = -1;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (this.scrollClicked && this.clickedDelta != -1 && this.scrollEnabled) {
            this.scrollButtonPos = (int)mouseY - y - this.clickedDelta;
        }
        if (this.scrollButtonPos > 56) {
            this.scrollButtonPos = 56;
        } else if (this.scrollButtonPos < 18) {
            this.scrollButtonPos = 18;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (mouseX >= (double)(x + 152) && mouseX <= (double)(x + 162) && mouseY >= (double)(y + this.scrollButtonPos) && mouseY <= (double)(y + this.scrollButtonPos + 13) && this.scrollEnabled) {
            this.scrollClicked = true;
            this.clickedDelta = (int)mouseY - (y + this.scrollButtonPos);
        } else {
            this.mouseClickedOnPanel(mouseX, mouseY);
        }
        return true;
    }

    public void mouseClickedOnPanel(double mouseX, double mouseY) {
        long playerXP = ExperienceUtils.levelsToXP(((PrecisionDispellerMenu)this.f_97732_).player.f_36078_) + Math.round(((PrecisionDispellerMenu)this.f_97732_).player.f_36080_ * (float)((PrecisionDispellerMenu)this.f_97732_).player.m_36323_());
        for (SelectablePanel panel : this.selectablePanels) {
            boolean invalid;
            if (((PrecisionDispellerMenu)this.f_97732_).player.m_7500_() || !panel.enchantment.m_6589_()) {
                invalid = false;
            } else if (!this.dispeller.obeliskStillExists) {
                invalid = playerXP < 1395L;
            } else {
                boolean bl = invalid = playerXP + (long)this.dispeller.obeliskPoints < 1395L;
            }
            if (!panel.isHovered(mouseX, mouseY) || !panel.isVisible || invalid) continue;
            if (this.selectedIndex == this.selectablePanels.indexOf(panel)) {
                this.selectedIndex = -1;
                PacketHandler.INSTANCE.sendToServer((Object)new UpdateSlot(1, ItemStack.f_41583_));
            } else {
                ItemStack outputItem;
                this.selectedIndex = this.selectablePanels.indexOf(panel);
                ItemStack inputItem = ((PrecisionDispellerMenu)this.f_97732_).container.m_8020_(0);
                Map map = EnchantmentHelper.m_44831_((ItemStack)inputItem);
                map.remove(panel.enchantment);
                if (inputItem.m_150930_(Items.f_42690_)) {
                    if (map.isEmpty()) {
                        outputItem = new ItemStack((ItemLike)Items.f_42517_, 1);
                    } else {
                        outputItem = new ItemStack((ItemLike)Items.f_42690_, 1);
                        for (Map.Entry entry : map.entrySet()) {
                            EnchantedBookItem.m_41153_((ItemStack)outputItem, (EnchantmentInstance)new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                        }
                    }
                } else {
                    outputItem = inputItem.m_41777_();
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)outputItem);
                    int repairCost = outputItem.m_41610_();
                    repairCost = (repairCost - 1) / 2;
                    if (repairCost < 1 || !outputItem.m_41793_()) {
                        repairCost = 0;
                    }
                    outputItem.m_41742_(repairCost);
                }
                PacketHandler.INSTANCE.sendToServer((Object)new UpdateSlot(1, outputItem));
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    private static class SelectablePanel {
        public Enchantment enchantment;
        public int level;
        public int x1;
        public int x2;
        public int y1;
        public int y2;
        public Status status;
        boolean isVisible;

        private SelectablePanel(int x1, int y1, Enchantment e, int level, Status s, boolean isVisible) {
            this.enchantment = e;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x1 + 102;
            this.y2 = y1 + 17;
            this.level = level;
            this.status = s;
            this.isVisible = isVisible;
        }

        public boolean isHovered(double mouseX, double mouseY) {
            return mouseX > (double)this.x1 && mouseX < (double)this.x2 && mouseY > (double)this.y1 && mouseY < (double)this.y2;
        }

        public void renderPanel(PoseStack posestack) {
            switch (this.status) {
                case UNHOVERED: {
                    GuiComponent.m_93133_((PoseStack)posestack, (int)this.x1, (int)this.y1, (float)0.0f, (float)177.0f, (int)102, (int)17, (int)256, (int)256);
                    break;
                }
                case HOVERED: {
                    GuiComponent.m_93133_((PoseStack)posestack, (int)this.x1, (int)this.y1, (float)0.0f, (float)211.0f, (int)102, (int)17, (int)256, (int)256);
                    break;
                }
                case SELECTED: {
                    GuiComponent.m_93133_((PoseStack)posestack, (int)this.x1, (int)this.y1, (float)0.0f, (float)194.0f, (int)102, (int)17, (int)256, (int)256);
                }
            }
        }

        public String getFullName() {
            Component fullName = this.enchantment.m_44700_(this.level);
            return fullName.m_6881_().getString();
        }

        public void renderText(PoseStack posestack, Font font) {
            Object text = this.getFullName();
            if (font.m_92895_((String)text) > 90) {
                while (font.m_92895_((String)text) > 90) {
                    text = ((String)text).substring(0, ((String)text).length() - 1);
                }
                text = (String)text + "...";
            }
            if (this.enchantment.m_6589_()) {
                font.m_92883_(posestack, (String)text, (float)(this.x1 + 4), (float)(this.y1 + 4), 16536660);
            } else {
                font.m_92883_(posestack, (String)text, (float)(this.x1 + 4), (float)(this.y1 + 4), 0xFFFFFF);
            }
        }
    }

    static enum Status {
        UNHOVERED,
        HOVERED,
        SELECTED;

    }
}

