/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.block_entities.ExperienceReceivingEntity;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class PrecisionDispellerEntity
extends ExperienceReceivingEntity
implements IAnimatable {
    public boolean pendingAnimation = false;
    protected static final AnimationBuilder USE = new AnimationBuilder().addAnimation("use").addAnimation("static");
    private final AnimationFactory manager = GeckoLibUtil.createFactory((IAnimatable)this);

    public PrecisionDispellerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.PRECISION_DISPELLER_BE.get(), pos, state);
    }

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLengthTicks = 0.0;
        if (controller.getAnimationState() == AnimationState.Stopped && this.pendingAnimation) {
            controller.setAnimation(new AnimationBuilder().addAnimation("use").addAnimation("static"));
            this.pendingAnimation = false;
            controller.markNeedsReload();
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("PendingAnimation", this.pendingAnimation);
        return tag;
    }

    @Override
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.pendingAnimation = tag.m_128471_("PendingAnimation");
        }
        super.onDataPacket(net, pkt);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof PrecisionDispellerEntity) {
            PrecisionDispellerEntity dispeller = (PrecisionDispellerEntity)((Object)blockEntity);
            dispeller.sendObeliskInfoToScreen();
        }
    }
}

