/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.block_entities.ExperienceObeliskEntity;
import com.cyanogen.experienceobelisk.block_entities.ExperienceReceivingEntity;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ExperienceFountainEntity
extends ExperienceReceivingEntity
implements IAnimatable {
    private final AnimationFactory manager = GeckoLibUtil.createFactory((IAnimatable)this);
    private int activityState = 0;
    public boolean hasPlayerAbove = false;

    public ExperienceFountainEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.EXPERIENCE_FOUNTAIN_BE.get(), pos, state);
    }

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLengthTicks = 0.0;
        BlockEntity entity = (BlockEntity)event.getAnimatable();
        if (this.f_58857_ != null && entity instanceof ExperienceFountainEntity) {
            boolean isActive;
            ExperienceFountainEntity fountain = (ExperienceFountainEntity)entity;
            boolean hasNeighborSignal = this.f_58857_.m_46753_(fountain.m_58899_());
            boolean bl = isActive = fountain.isBound && (hasNeighborSignal || fountain.hasPlayerAbove);
            if (controller.getCurrentAnimation() == null || !this.toName(fountain.activityState, isActive).equals(controller.getCurrentAnimation().animationName)) {
                switch (fountain.activityState) {
                    case 0: {
                        if (isActive) {
                            controller.setAnimation(new AnimationBuilder().addAnimation("active-slow"));
                            break;
                        }
                        controller.setAnimation(new AnimationBuilder().addAnimation("slow"));
                        break;
                    }
                    case 1: {
                        if (isActive) {
                            controller.setAnimation(new AnimationBuilder().addAnimation("active-moderate"));
                            break;
                        }
                        controller.setAnimation(new AnimationBuilder().addAnimation("moderate"));
                        break;
                    }
                    case 2: {
                        if (isActive) {
                            controller.setAnimation(new AnimationBuilder().addAnimation("active-fast"));
                            break;
                        }
                        controller.setAnimation(new AnimationBuilder().addAnimation("fast"));
                        break;
                    }
                    case 3: {
                        if (isActive) {
                            controller.setAnimation(new AnimationBuilder().addAnimation("active-hyperspeed"));
                            break;
                        }
                        controller.setAnimation(new AnimationBuilder().addAnimation("hyperspeed"));
                    }
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "experience_fountain_block_controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof ExperienceFountainEntity) {
            ExperienceFountainEntity fountain = (ExperienceFountainEntity)((Object)blockEntity);
            if (fountain.isBound) {
                int z;
                int y;
                BlockEntity boundEntity = level.m_7702_(fountain.getBoundPos());
                int x = pos.m_123341_();
                List playerList = level.m_45976_(Player.class, new AABB((double)x + 0.25, (double)(y = pos.m_123342_()) + 0.5, (double)(z = pos.m_123343_()) + 0.25, (double)x + 0.75, (double)y + 1.065, (double)z + 0.75));
                if (!playerList.isEmpty() && !fountain.hasPlayerAbove) {
                    level.m_5594_(null, pos, SoundEvents.f_12637_, SoundSource.BLOCKS, 0.2f, 0.6f);
                    fountain.hasPlayerAbove = true;
                    level.m_7260_(pos, state, state, 2);
                } else if (playerList.isEmpty() && fountain.hasPlayerAbove) {
                    level.m_5594_(null, pos, SoundEvents.f_12636_, SoundSource.BLOCKS, 0.2f, 0.2f);
                    fountain.hasPlayerAbove = false;
                    level.m_7260_(pos, state, state, 2);
                }
                if (boundEntity instanceof ExperienceObeliskEntity) {
                    ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)boundEntity;
                    if (!level.f_46443_ && obelisk.getFluidAmount() > 0 && (level.m_46753_(pos) || fountain.hasPlayerAbove)) {
                        int value = 4;
                        int interval = 20;
                        switch (fountain.getActivityState()) {
                            case 1: {
                                value = 20;
                                interval = 10;
                                break;
                            }
                            case 2: {
                                value = 100;
                                interval = 5;
                                break;
                            }
                            case 3: {
                                value = 400;
                                interval = 2;
                            }
                        }
                        if (value > obelisk.getFluidAmount() / 20) {
                            value = obelisk.getFluidAmount() / 20;
                        }
                        if (level.m_46467_() % (long)interval == 0L) {
                            ServerLevel server = (ServerLevel)level;
                            ExperienceOrb orb = new ExperienceOrb((Level)server, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, value);
                            obelisk.drain(value * 20);
                            orb.m_20334_(0.0, 0.25, 0.0);
                            server.m_7967_((Entity)orb);
                        }
                    }
                }
            }
        }
    }

    public int getActivityState() {
        return this.activityState;
    }

    public void cycleActivityState() {
        ++this.activityState;
        if (this.activityState > 3) {
            this.activityState = 0;
        }
        this.m_6596_();
    }

    public String toName(int activityState, boolean isActive) {
        switch (activityState) {
            case 0: {
                return isActive ? "active-slow" : "slow";
            }
            case 1: {
                return isActive ? "active-moderate" : "moderate";
            }
            case 2: {
                return isActive ? "active-fast" : "fast";
            }
            case 3: {
                return isActive ? "active-hyperspeed" : "hyperspeed";
            }
        }
        return null;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.activityState = tag.m_128451_("ActivityState");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("ActivityState", this.activityState);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("ActivityState", this.activityState);
        return tag;
    }

    @Override
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.activityState = tag.m_128451_("ActivityState");
            this.hasPlayerAbove = tag.m_128471_("PlayerAbove");
        }
        super.onDataPacket(net, pkt);
    }
}

