/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block.bibliophage;

import com.cyanogen.experienceobelisk.block.bibliophage.BookshelfBlock;
import com.cyanogen.experienceobelisk.block_entities.bibliophage.AbstractInfectedBookshelfEntity;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class InfectedBookshelfBlock
extends BookshelfBlock
implements EntityBlock {
    public InfectedBookshelfBlock(float enchantPowerBonus) {
        super(enchantPowerBonus);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        Entity e;
        if (context instanceof EntityCollisionContext && (e = (entityCollisionContext = (EntityCollisionContext)context).m_193113_()) instanceof ExperienceOrb) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, getter, pos, context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)RegisterItems.ATTUNEMENT_STAFF.get()) && !player.m_6144_() && (blockEntity = level.m_7702_(pos)) instanceof AbstractInfectedBookshelfEntity) {
            AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)blockEntity;
            int decayValue = bookshelf.getDecayValue();
            int spawns = bookshelf.getSpawns();
            int durability = 100 - decayValue * 100 / spawns;
            MutableComponent durabilityStatus = Component.m_237113_((String)(durability + "%"));
            if (durability > 50) {
                durabilityStatus.m_130940_(ChatFormatting.GREEN);
            } else if (durability > 25) {
                durabilityStatus.m_130940_(ChatFormatting.YELLOW);
            } else {
                durabilityStatus.m_130940_(ChatFormatting.RED);
            }
            MutableComponent message = Component.m_237110_((String)"message.experienceobelisk.binding_wand.query_bookshelf", (Object[])new Object[]{durabilityStatus});
            if (!level.f_46443_) {
                player.m_5661_((Component)message, true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractInfectedBookshelfEntity) {
            AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)blockEntity;
            int remaining = bookshelf.getSpawns() - bookshelf.getDecayValue();
            int remainingProduction = remaining * bookshelf.getOrbValue();
            int totalValue = (int)((double)remainingProduction * 0.377 * Math.random());
            int orbCount = (int)(2.0 + Math.random() * 3.0);
            int orbValue = totalValue / orbCount;
            if (!level.f_46443_ && totalValue > 10 && !player.m_7500_()) {
                ServerLevel server = (ServerLevel)level;
                for (int i = 0; i < orbCount; ++i) {
                    server.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, orbValue));
                }
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == RegisterBlockEntities.INFECTED_BOOKSHELF_BE.get() ? AbstractInfectedBookshelfEntity::tick : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)RegisterBlockEntities.INFECTED_BOOKSHELF_BE.get()).m_155264_(pos, state);
    }
}

