/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.client;

import alexthw.starbunclemania.common.block.LiquidJarTile;
import alexthw.starbunclemania.common.item.FluidJarItem;
import com.hollingsworth.arsnouveau.client.renderer.item.FixedGeoItemRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;

public class JarRenderer
implements BlockEntityRenderer<LiquidJarTile> {
    public static final Vector3f LIQUID_DIMENSIONS = new Vector3f(0.5625f, 0.59375f, 0.0625f);

    public static void renderFluid(float percentageFill, int color, int luminosity, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int light, boolean shading, Vector3f fluidVec) {
        matrixStackIn.m_85836_();
        float opacity = 1.0f;
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110469_());
        matrixStackIn.m_85837_(0.5, (double)fluidVec.m_122269_(), 0.5);
        JarRenderer.addCube(builder, matrixStackIn, fluidVec.m_122239_(), percentageFill * fluidVec.m_122260_(), sprite, light, color, opacity, true, true, shading, true);
        matrixStackIn.m_85849_();
    }

    public void render(LiquidJarTile tile, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        FluidStack fluidHolder = tile.getFluid();
        if (!fluidHolder.isEmpty()) {
            JarRenderer.renderFluid(tile.getFluidPercentage(), IClientFluidTypeExtensions.of((Fluid)fluidHolder.getFluid()).getTintColor(fluidHolder), fluidHolder.getFluid().getFluidType().getLightLevel(), IClientFluidTypeExtensions.of((Fluid)fluidHolder.getFluid()).getStillTexture(), pPoseStack, pBufferSource, pPackedLight, true, LIQUID_DIMENSIONS);
        }
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        JarRenderer.addCube(builder, matrixStackIn, 0.0f, 0.0f, w, h, sprite, combinedLightIn, color, a, up, down, fakeshading, flippedY, false);
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, boolean up, boolean down, boolean fakeshading, boolean flippedY, boolean wrap) {
        float b5;
        float g5;
        float r5;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasScaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasScaleV = sprite.m_118412_() - sprite.m_118411_();
        float minU = sprite.m_118409_() + atlasScaleU * uOff;
        float minV = sprite.m_118411_() + atlasScaleV * vOff;
        float maxU = minU + atlasScaleU * w;
        float maxV = minV + atlasScaleV * h;
        float maxV2 = minV + atlasScaleV * w;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float r6 = r5 = r;
        float r8 = r5;
        float g6 = g5 = g;
        float g8 = g5;
        float b6 = b5 = b;
        float b8 = b5;
        if (fakeshading) {
            float s1 = 0.8f;
            float s2 = 0.6f;
            float s3 = 0.5f;
            r8 *= s1;
            g8 *= s1;
            b8 *= s1;
            r6 *= s2;
            g6 *= s2;
            b6 *= s2;
            r5 *= s3;
            g5 *= s3;
            b5 *= s3;
        }
        float hw = w / 2.0f;
        if (up) {
            JarRenderer.addQuadTop(builder, matrixStackIn, -hw, h, hw, hw, h, -hw, minU, minV, maxU, maxV2, r, g, b, a, lu, lv, 0.0f, 1.0f, 0.0f);
        }
        if (down) {
            JarRenderer.addQuadTop(builder, matrixStackIn, -hw, 0.0f, -hw, hw, 0.0f, hw, minU, minV, maxU, maxV2, r5, g5, b5, a, lu, lv, 0.0f, -1.0f, 0.0f);
        }
        if (flippedY) {
            float temp = minV;
            minV = maxV;
            maxV = temp;
        }
        float inc = 0.0f;
        if (wrap) {
            inc = atlasScaleU * w;
        }
        JarRenderer.addQuadSide(builder, matrixStackIn, hw, 0.0f, -hw, -hw, h, -hw, minU, minV, maxU, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, 1.0f);
        JarRenderer.addQuadSide(builder, matrixStackIn, -hw, 0.0f, -hw, -hw, h, hw, minU + inc, minV, maxU + inc, maxV, r6, g6, b6, a, lu, lv, -1.0f, 0.0f, 0.0f);
        JarRenderer.addQuadSide(builder, matrixStackIn, -hw, 0.0f, hw, hw, h, hw, minU + 2.0f * inc, minV, maxU + 2.0f * inc, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, -1.0f);
        JarRenderer.addQuadSide(builder, matrixStackIn, hw, 0.0f, hw, hw, h, -hw, minU + 3.0f * inc, minV, maxU + 3.0f * inc, maxV, r6, g6, b6, a, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static void addQuadSide(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        JarRenderer.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadTop(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        JarRenderer.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x1, y0, z0, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x0, y1, z1, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.m_85982_(matrixStackIn.m_85850_().m_85861_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_7120_(lu, lv).m_85977_(matrixStackIn.m_85850_().m_85864_(), nx, ny, nz).m_5752_();
    }

    public static class ISTER
    extends FixedGeoItemRenderer<FluidJarItem> {
        public ISTER() {
            super((AnimatedGeoModel)new GenericModel("fluid_jar"));
        }

        public void m_108829_(ItemStack pStack, ItemTransforms.TransformType pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
            FluidStack fluid;
            super.m_108829_(pStack, pTransformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 0.5, 0.0);
            if (pStack.m_41720_() instanceof FluidJarItem && !(fluid = FluidJarItem.getFluidFromTag(pStack)).isEmpty()) {
                float percentage = pStack.m_41784_().m_128441_("Starbuncle") ? 1.0f : (float)fluid.getAmount() / (float)LiquidJarTile.capacity;
                JarRenderer.renderFluid(percentage, IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid), fluid.getFluid().getFluidType().getLightLevel(), IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(), pPoseStack, pBuffer, pPackedLight, true, LIQUID_DIMENSIONS);
            }
            pPoseStack.m_85849_();
        }
    }
}

