/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.data.traits;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import me.codexadrian.spirit.data.MobTrait;
import me.codexadrian.spirit.data.MobTraitSerializer;
import me.codexadrian.spirit.data.ToolType;
import me.codexadrian.spirit.entity.SoulArrowEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public record PotionTrait(List<MobEffectInstance> effects) implements MobTrait<PotionTrait>
{
    public static final Serializer SERIALIZER = new Serializer();

    @Override
    public void initializeArrow(SoulArrowEntity soulArrow) {
        for (MobEffectInstance effect : this.effects()) {
            soulArrow.m_36870_(new MobEffectInstance(effect));
        }
    }

    @Override
    public void onHitBlock(ToolType type, Entity entity, BlockState blockState, Level level, BlockPos pos) {
        AreaEffectCloud potionCloud = (AreaEffectCloud)EntityType.f_20476_.m_20615_(entity.f_19853_);
        if (potionCloud == null) {
            return;
        }
        for (MobEffectInstance effect : this.effects()) {
            potionCloud.m_19716_(new MobEffectInstance(effect));
        }
        potionCloud.m_19734_(60);
        potionCloud.m_19712_(1.0f);
        potionCloud.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        level.m_7967_((Entity)potionCloud);
    }

    @Override
    public void onHitEntity(ToolType type, Entity attacker, Entity victim) {
        if (type == ToolType.BOW) {
            return;
        }
        if (victim instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)victim;
            for (MobEffectInstance effect : this.effects()) {
                livingEntity.m_7292_(new MobEffectInstance(effect));
            }
        }
    }

    @Override
    public MobTraitSerializer<PotionTrait> serializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements MobTraitSerializer<PotionTrait> {
        public static Codec<MobEffectInstance> EFFECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122823_.m_194605_().fieldOf("effect").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.fieldOf("duration").orElse((Object)0).forGetter(MobEffectInstance::m_19557_), (App)Codec.INT.fieldOf("amplifier").orElse((Object)0).forGetter(MobEffectInstance::m_19564_), (App)Codec.BOOL.fieldOf("ambient").orElse((Object)false).forGetter(MobEffectInstance::m_19571_), (App)Codec.BOOL.fieldOf("visible").orElse((Object)true).forGetter(MobEffectInstance::m_19572_), (App)Codec.BOOL.fieldOf("showIcon").orElse((Object)true).forGetter(MobEffectInstance::m_19575_), (App)MobEffectInstance.FactorData.f_216907_.optionalFieldOf("factorData").forGetter(MobEffectInstance::m_216895_)).apply((Applicative)instance, Serializer::mobEffectInstanceOf));
        public static final Codec<PotionTrait> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EFFECT_CODEC.listOf().fieldOf("effects").forGetter(PotionTrait::effects)).apply((Applicative)instance, PotionTrait::new));

        private Serializer() {
        }

        @Override
        public ResourceLocation id() {
            return new ResourceLocation("spirit", "potion_effect");
        }

        @Override
        public Codec<PotionTrait> codec() {
            return CODEC;
        }

        public static MobEffectInstance mobEffectInstanceOf(MobEffect effect, int dur, int amp, boolean ambient, boolean visible, boolean icon, Optional<MobEffectInstance.FactorData> data) {
            return new MobEffectInstance(effect, dur, amp, ambient, visible, icon, null, data);
        }
    }
}

