/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.blocks.blockentity;

import me.codexadrian.spirit.Corrupted;
import me.codexadrian.spirit.blocks.blockentity.SoulCageBlockEntity;
import me.codexadrian.spirit.data.Tier;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class SoulCageSpawner {
    private double spin;
    private int spawnDelay = 20;
    private final SoulCageBlockEntity soulCageBlockEntity;

    public SoulCageSpawner(SoulCageBlockEntity entity) {
        this.soulCageBlockEntity = entity;
    }

    public void tick() {
        Level level = this.getLevel();
        BlockPos blockPos = this.getPos();
        if (level.f_46443_) {
            if (this.isNearPlayer()) {
                double spinAmount = 20.0;
                Tier tier = SoulUtils.getTier(this.soulCageBlockEntity.m_8020_(0), level);
                if (tier != null && tier.redstoneControlled() && level.m_46753_(this.soulCageBlockEntity.m_58899_())) {
                    spinAmount /= 30.0;
                } else {
                    double d = (double)blockPos.m_123341_() + level.f_46441_.m_188500_();
                    double e = (double)blockPos.m_123342_() + level.f_46441_.m_188500_();
                    double f = (double)blockPos.m_123343_() + level.f_46441_.m_188500_();
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, d, e, f, 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d, e, f, 0.0, 0.0, 0.0);
                }
                this.spin = (this.spin + spinAmount) % 360.0;
            }
        } else if (this.isNearPlayer()) {
            Tier tier = SoulUtils.getTier(this.soulCageBlockEntity.m_8020_(0), level);
            if (tier == null) {
                return;
            }
            if (this.spawnDelay == -1) {
                this.delay(tier);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            if (tier.redstoneControlled() && level.m_46753_(this.soulCageBlockEntity.m_58899_())) {
                return;
            }
            boolean bl = false;
            int i = 0;
            while (true) {
                double z;
                double y;
                if (i >= tier.spawnCount()) {
                    if (!bl) break;
                    this.delay(tier);
                    break;
                }
                if (this.soulCageBlockEntity.type == null) {
                    this.delay(tier);
                    return;
                }
                double x = (double)blockPos.m_123341_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * (double)tier.spawnRange() + 0.5;
                if (level.m_45772_(this.soulCageBlockEntity.type.m_20585_(x, y = (double)(blockPos.m_123342_() + level.f_46441_.m_188503_(3) - 1), z = (double)blockPos.m_123343_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * (double)tier.spawnRange() + 0.5))) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (tier.ignoreSpawnConditions() || SpawnPlacements.m_217074_(this.soulCageBlockEntity.type, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)new BlockPos(x, y, z), (RandomSource)level.m_213780_())) {
                        Mob mob;
                        Entity spawned = this.soulCageBlockEntity.type.m_20615_(level);
                        if (spawned == null) {
                            this.delay(tier);
                            return;
                        }
                        ((Corrupted)spawned).setCorrupted();
                        spawned.m_7678_(x, y, z, spawned.m_146908_(), spawned.m_146909_());
                        int l = level.m_45976_(spawned.getClass(), new AABB(blockPos).m_82400_((double)tier.spawnRange())).size();
                        if (l >= 6) {
                            this.delay(tier);
                            return;
                        }
                        spawned.m_7678_(spawned.m_20185_(), spawned.m_20186_(), spawned.m_20189_(), level.f_46441_.m_188501_() * 360.0f, 0.0f);
                        if (spawned instanceof Mob) {
                            mob = (Mob)spawned;
                            if (!tier.ignoreSpawnConditions() && !mob.m_5545_((LevelAccessor)level, MobSpawnType.SPAWNER) || !mob.m_6914_((LevelReader)level)) {
                                this.delay(tier);
                                return;
                            }
                            mob.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(spawned.m_20183_()), MobSpawnType.SPAWNER, null, null);
                        }
                        if (!serverLevel.m_8860_(spawned)) {
                            this.delay(tier);
                            return;
                        }
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 20, 1.0, 1.0, 1.0, 0.0);
                        if (spawned instanceof Mob) {
                            mob = (Mob)spawned;
                            mob.m_21373_();
                        }
                        bl = true;
                    }
                }
                ++i;
            }
        }
    }

    private boolean isNearPlayer() {
        BlockPos blockPos = this.getPos();
        BlockState blockState = this.getLevel().m_8055_(this.getPos());
        if (blockState.m_60713_(SpiritBlocks.SOUL_CAGE.get())) {
            Tier tier = SoulUtils.getTier(this.soulCageBlockEntity.m_8020_(0), this.getLevel());
            if (tier == null) {
                return false;
            }
            if (tier.nearbyRange() > 0) {
                return this.getLevel().m_45914_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, (double)tier.nearbyRange());
            }
            return true;
        }
        return false;
    }

    private void delay(Tier tier) {
        this.spawnDelay = tier.maxSpawnDelay() <= tier.minSpawnDelay() ? tier.minSpawnDelay() : tier.minSpawnDelay() + this.getLevel().f_46441_.m_188503_(tier.maxSpawnDelay() - tier.minSpawnDelay());
        this.broadcastEvent(1);
    }

    public boolean onEventTriggered(int i) {
        if (i == 1 && this.getLevel().m_5776_()) {
            Tier tier = SoulUtils.getTier(this.soulCageBlockEntity.m_8020_(0), this.getLevel());
            if (tier == null) {
                return false;
            }
            this.spawnDelay = tier.minSpawnDelay();
            return true;
        }
        return false;
    }

    public void broadcastEvent(int i) {
        Level level = this.soulCageBlockEntity.m_58904_();
        if (level != null) {
            level.m_7696_(this.soulCageBlockEntity.m_58899_(), SpiritBlocks.SOUL_CAGE.get(), i, 0);
        }
    }

    public Level getLevel() {
        return this.soulCageBlockEntity.m_58904_();
    }

    public BlockPos getPos() {
        return this.soulCageBlockEntity.m_58899_();
    }

    public double getSpin() {
        return this.spin;
    }
}

