/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.Network;
import cpw.mods.inventorysorter.ScrollWheelHandler;
import cpw.mods.inventorysorter.SortingHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.inventory.Slot;

public enum Action {
    SORT(SortingHandler.INSTANCE, "key.inventorysorter.sort", 2, "middleClickSorting", "Middle-click sorting module", true, InventorySorter.INSTANCE::sortingModConflicts),
    ONEITEMIN(ScrollWheelHandler.ONEITEMIN, "key.inventorysorter.itemin", 99, "mouseWheelMoving", "Mouse wheel movement module", true, InventorySorter.INSTANCE::wheelModConflicts),
    ONEITEMOUT(ScrollWheelHandler.ONEITEMOUT, "key.inventorysorter.itemout", 101, "mouseWheelMoving", "Mouse wheel movement module", true, InventorySorter.INSTANCE::wheelModConflicts);

    private final Consumer<ContainerContext> worker;
    private final String keyBindingName;
    private final int defaultKeyCode;
    private final String configName;
    private boolean actionActive;
    private final String comment;
    private final boolean implemented;
    private final Supplier<Boolean> checkForConflicts;

    private Action(Consumer<ContainerContext> worker, String keyBindingName, int defaultKeyCode, String configName, String comment, boolean implemented, Supplier<Boolean> checkForConflicts) {
        this.worker = worker;
        this.keyBindingName = keyBindingName;
        this.defaultKeyCode = defaultKeyCode;
        this.configName = configName;
        this.comment = comment;
        this.implemented = implemented;
        this.checkForConflicts = checkForConflicts;
    }

    public String getKeyBindingName() {
        return this.keyBindingName;
    }

    public Network.ActionMessage message(Slot slot) {
        return new Network.ActionMessage(this, slot.f_40219_);
    }

    public void execute(ContainerContext context) {
        this.worker.accept(context);
    }

    public boolean isActive() {
        return true;
    }

    public String getConfigName() {
        return this.configName;
    }

    public int getDefaultKeyCode() {
        return this.defaultKeyCode;
    }
}

