/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate;

import com.eeeab.animate.server.ai.AnimationGroupAI;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.entity.util.TickBasedProbabilityBooster;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ImmortalComboGoal
extends AnimationGroupAI<EntityImmortal> {
    private final TickBasedProbabilityBooster consecutivePunchProb = new TickBasedProbabilityBooster(0.2f, 0.05f, 0.5f);
    private final TickBasedProbabilityBooster criticalHitProb = new TickBasedProbabilityBooster(0.1f, 0.01f, 0.25f);
    private static final float PUNCH_ATTACK_RANGE = 4.5f;
    private boolean comboFlag;

    public ImmortalComboGoal(EntityImmortal entity) {
        super(entity, () -> entity.punchRightAnimation, () -> entity.hardPunchRightAnimation, () -> entity.punchLeftAnimation, () -> entity.hardPunchLeftAnimation);
    }

    @Override
    public void m_8041_() {
        ((EntityImmortal)this.entity).canInterruptsAnimation = false;
        super.m_8041_();
        this.comboFlag = false;
        this.consecutivePunchProb.resetProbability();
    }

    public void m_8037_() {
        LivingEntity target = ((EntityImmortal)this.entity).m_5448_();
        Animation animation = ((EntityImmortal)this.entity).getAnimation();
        int tick = ((EntityImmortal)this.entity).getAnimationTick();
        if (animation == ((EntityImmortal)this.entity).punchRightAnimation || animation == ((EntityImmortal)this.entity).punchLeftAnimation) {
            boolean left;
            if (tick < 11) {
                ((EntityImmortal)this.entity).anchorToGround();
            }
            if (tick <= 12 || tick > 20) {
                if (target != null) {
                    ((EntityImmortal)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                    ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                } else {
                    ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
                }
            }
            boolean bl = left = animation == ((EntityImmortal)this.entity).punchLeftAnimation;
            if (tick == 10) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK.get(), 1.5f, ((EntityImmortal)this.entity).m_6100_());
            }
            if (tick == 11) {
                ((EntityImmortal)this.entity).pursuit(5.0f, 0.0f, 0.35);
            } else if (tick >= 14 && tick <= 16) {
                this.doHurtTargetAndTryBreakBlock(4.5f, left ? 40.0f : 120.0f, left ? 120.0f : 40.0f, 0.5f, tick > 14, false, tick == 14, false, false, 0.02f, 0.89f, 1.0f);
            } else if (tick > 16) {
                if (!this.comboFlag && ((EntityImmortal)this.entity).checkComboRange(5.0, 1.0) && tick > 20 && tick < 25) {
                    Animation[] animationArray = new Animation[1];
                    Animation animation2 = animationArray[0] = left ? ((EntityImmortal)this.entity).hardPunchRightAnimation : ((EntityImmortal)this.entity).hardPunchLeftAnimation;
                    if (this.nextAnimation(animation, ((EntityImmortal)this.entity).m_217043_().m_188501_() < this.criticalHitProb.getProbability(), animationArray)) {
                        this.criticalHitProb.resetProbability();
                        this.comboFlag = true;
                    } else {
                        Animation[] animationArray2 = new Animation[1];
                        Animation animation3 = animationArray2[0] = left ? ((EntityImmortal)this.entity).punchRightAnimation : ((EntityImmortal)this.entity).punchLeftAnimation;
                        if (this.nextAnimation(animation, ((EntityImmortal)this.entity).m_217043_().m_188501_() < this.consecutivePunchProb.onTick().getProbability(), animationArray2)) {
                            this.criticalHitProb.onTick();
                            this.comboFlag = true;
                        }
                    }
                } else if (tick >= 26) {
                    if (this.comboFlag) {
                        if (tick == 26) {
                            ((EntityImmortal)this.entity).canInterruptsAnimation = true;
                        } else if (tick <= 30 && ((EntityImmortal)this.entity).getHealthPercentage() < 80.0f && ((EntityImmortal)this.entity).m_217043_().m_188503_(10) == 0) {
                            ((EntityImmortal)this.entity).canInterruptsAnimation = false;
                            this.nextAnimation(animation, true, left ? ((EntityImmortal)this.entity).hardPunchRightAnimation : ((EntityImmortal)this.entity).hardPunchLeftAnimation);
                        }
                    } else if (tick == 30) {
                        ((EntityImmortal)this.entity).canInterruptsAnimation = true;
                    }
                }
            }
        } else if (animation == ((EntityImmortal)this.entity).hardPunchRightAnimation || animation == ((EntityImmortal)this.entity).hardPunchLeftAnimation) {
            if (tick < 20) {
                ((EntityImmortal)this.entity).anchorToGround();
            }
            if (tick < 20 || tick > 34) {
                if (target != null) {
                    ((EntityImmortal)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                    ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                }
            } else {
                ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
            }
            if (tick == 19) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK2.get(), 1.5f, 1.4f);
            }
            if (tick >= 21 && tick < 24) {
                boolean left;
                boolean bl = left = animation == ((EntityImmortal)this.entity).hardPunchLeftAnimation;
                if (tick == 21) {
                    ((EntityImmortal)this.entity).pursuit(6.0f, 0.0f, 0.5);
                }
                this.doHurtTargetAndTryBreakBlock(5.0f, left ? 20.0f : 90.0f, left ? 90.0f : 20.0f, 1.0f, tick < 23, true, tick < 23, true, tick < 23, 0.04f, 0.9f, 0.8f);
            }
        }
    }

    private void doHurtTargetAndTryBreakBlock(float attackDistance, float rightAttackArc, float leftAttackArc, float strength, boolean continuous, boolean disableShied, boolean canHit, boolean ignoreArmor, boolean canStun, float hitEntityMaxHealth, float baseDamageMultiplier, float damageMultiplier) {
        float attackArc = rightAttackArc + leftAttackArc;
        List<LivingEntity> entitiesHit = ((EntityImmortal)this.entity).getNearByLivingEntities(attackDistance, 4.5, attackDistance, attackDistance);
        boolean hitFlag = false;
        for (LivingEntity entityHit : entitiesHit) {
            float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, entityHit);
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - ((EntityImmortal)this.entity).m_20189_()) * (entityHit.m_20189_() - ((EntityImmortal)this.entity).m_20189_()) + (entityHit.m_20185_() - ((EntityImmortal)this.entity).m_20185_()) * (entityHit.m_20185_() - ((EntityImmortal)this.entity).m_20185_())) - entityHit.m_20205_() / 2.0f;
            if (!(entityHitDistance <= attackDistance) || !(entityRelativeAngle >= -leftAttackArc / 2.0f && entityRelativeAngle <= rightAttackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f) && !(entityRelativeAngle <= -360.0f + attackArc / 2.0f)) continue;
            boolean hit = true;
            if (canHit) {
                if (canStun) {
                    ((EntityImmortal)this.entity).stun(null, entityHit, 30, false);
                }
                hit = ((EntityImmortal)this.entity).doHurtTarget(entityHit, disableShied, entityHit.m_21023_((MobEffect)EffectInit.ERODE_EFFECT.get()), true, ignoreArmor, hitEntityMaxHealth, baseDamageMultiplier, damageMultiplier);
                if (!disableShied) {
                    ((EntityImmortal)this.entity).disableShield(entityHit, 40);
                }
                if (!hitFlag) {
                    hitFlag = true;
                    if (hit) {
                        ((EntityImmortal)this.entity).m_5496_(disableShied ? (SoundEvent)SoundInit.IMMORTAL_PUNCH_HARD_HIT.get() : (SoundEvent)SoundInit.IMMORTAL_PUNCH_HIT.get(), 1.0f, disableShied ? 1.0f : 1.1f);
                    }
                    ((EntityImmortal)this.entity).shakeGround(0.0f, 20.0f, 0.3f, 1, 5);
                    ((EntityImmortal)this.entity).m_9236_().m_7605_((Entity)this.entity, (byte)(disableShied ? 7 : 6));
                }
            }
            ((EntityImmortal)this.entity).knockBack(entityHit, hit ? (double)strength : (double)strength - 0.2, hit && canHit ? 0.15 : 0.1, true, continuous);
        }
        if (canHit && ModEntityUtils.canMobDestroy((Entity)this.entity)) {
            int offset = (int)(attackDistance / 2.0f);
            if (ModEntityUtils.advancedBreakBlocks(((EntityImmortal)this.entity).m_9236_(), (LivingEntity)this.entity, 50.0f, offset, (int)attackDistance, offset, 0, offset, ((EntityImmortal)this.entity).checkCanDropItems(), true) && !hitFlag) {
                ((EntityImmortal)this.entity).m_9236_().m_7605_((Entity)this.entity, (byte)7);
            }
        }
    }
}

