/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.particle.base;

import com.eeeab.eeeabsmobs.client.render.EMRenderType;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.util.EMMathUtils;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ParticleRing
extends TextureSheetParticle {
    public float red;
    public float green;
    public float blue;
    public float alpha;
    public boolean facesCamera;
    public float yRot;
    public float xRot;
    public float scale;
    private final EnumRingBehavior behavior;

    public ParticleRing(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, float yRot, float xRot, int duration, float red, float green, float blue, float opacity, float scale, boolean facesCamera, EnumRingBehavior behavior) {
        super(world, x, y, z);
        this.f_107230_ = 1.0f;
        this.m_107250_(1.0f, 1.0f);
        this.scale = scale * 0.1f;
        this.f_107225_ = duration;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = opacity;
        this.yRot = yRot;
        this.xRot = xRot;
        this.facesCamera = facesCamera;
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.behavior = behavior;
    }

    public int m_6355_(float delta) {
        return 0xF0 | super.m_6355_(delta) & 0xFF0000;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107663_ = this.behavior == EnumRingBehavior.GROW ? this.scale * var : (this.behavior == EnumRingBehavior.SHRINK ? this.scale * (1.0f - var) : (this.behavior == EnumRingBehavior.GROW_THEN_SHRINK ? (float)((double)this.scale * ((double)(1.0f - var) - Math.pow(2000.0, -var))) : this.scale));
        this.alpha = this.alpha * 0.95f * (1.0f - ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_) + 0.05f;
        this.f_107227_ = this.red;
        this.f_107228_ = this.green;
        this.f_107229_ = this.blue;
        Vec3 vec3 = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternion = new Quaternionf();
        if (this.facesCamera) {
            if (this.f_107231_ == 0.0f) {
                quaternion = renderInfo.m_253121_();
            } else {
                quaternion = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
                float f3 = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
                quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
            }
        } else {
            Quaternionf quatX = EMMathUtils.rotationXYZ(this.xRot, 0.0f, 0.0f, false);
            Quaternionf quatY = EMMathUtils.rotationXYZ(0.0f, this.yRot, 0.0f, false);
            quaternion.mul((Quaternionfc)quatY);
            quaternion.mul((Quaternionfc)quatX);
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        quaternion.transform(vector3f1);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        float f6 = this.m_5970_();
        float f7 = this.m_5952_();
        float f4 = this.m_5951_();
        float f5 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        vertexConsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f7, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f6, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f6, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(j).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return EMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public static enum EnumRingBehavior {
        SHRINK,
        GROW,
        CONSTANT,
        GROW_THEN_SHRINK;

    }

    public static class RingData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<RingData> DESERIALIZER = new ParticleOptions.Deserializer<RingData>(){

            public RingData fromCommand(ParticleType<RingData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float yaw = (float)reader.readDouble();
                reader.expect(' ');
                float pitch = (float)reader.readDouble();
                reader.expect(' ');
                float r = (float)reader.readDouble();
                reader.expect(' ');
                float g = (float)reader.readDouble();
                reader.expect(' ');
                float b = (float)reader.readDouble();
                reader.expect(' ');
                float a = (float)reader.readDouble();
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                reader.expect(' ');
                boolean facesCamera = reader.readBoolean();
                return new RingData(yaw, pitch, duration, r, g, b, a, scale, facesCamera, EnumRingBehavior.GROW);
            }

            public RingData fromNetwork(ParticleType<RingData> particleTypeIn, FriendlyByteBuf buffer) {
                return new RingData(buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), EnumRingBehavior.GROW);
            }
        };
        private final float yRot;
        private final float xRot;
        private final float red;
        private final float green;
        private final float blue;
        private final float alpha;
        private final float scale;
        private final int duration;
        private final boolean facesCamera;
        private final EnumRingBehavior behavior;

        public RingData(float yRot, float pitch, int duration, float red, float g, float blue, float alpha, float scale, boolean facesCamera, EnumRingBehavior behavior) {
            this.yRot = yRot;
            this.xRot = pitch;
            this.red = red;
            this.green = g;
            this.blue = blue;
            this.alpha = alpha;
            this.scale = scale;
            this.duration = duration;
            this.facesCamera = facesCamera;
            this.behavior = behavior;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f %d %b", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.yRot), Float.valueOf(this.xRot), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.scale), Float.valueOf(this.alpha), this.duration, this.facesCamera);
        }

        public ParticleType<? extends RingData> m_6012_() {
            return (ParticleType)ParticleInit.RING.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getyRot() {
            return this.yRot;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getxRot() {
            return this.xRot;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getRed() {
            return this.red;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getGreen() {
            return this.green;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getBlue() {
            return this.blue;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getAlpha() {
            return this.alpha;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean getFacesCamera() {
            return this.facesCamera;
        }

        @OnlyIn(value=Dist.CLIENT)
        public EnumRingBehavior getBehavior() {
            return this.behavior;
        }

        public static Codec<RingData> CODEC(ParticleType<RingData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("yRot").forGetter(RingData::getyRot), (App)Codec.FLOAT.fieldOf("xRot").forGetter(RingData::getxRot), (App)Codec.FLOAT.fieldOf("red").forGetter(RingData::getRed), (App)Codec.FLOAT.fieldOf("green").forGetter(RingData::getGreen), (App)Codec.FLOAT.fieldOf("blue").forGetter(RingData::getBlue), (App)Codec.FLOAT.fieldOf("alpha").forGetter(RingData::getAlpha), (App)Codec.FLOAT.fieldOf("scale").forGetter(RingData::getScale), (App)Codec.INT.fieldOf("duration").forGetter(RingData::getDuration), (App)Codec.BOOL.fieldOf("facesCamera").forGetter(RingData::getFacesCamera), (App)Codec.STRING.fieldOf("behavior").forGetter(ringData -> ringData.getBehavior().toString())).apply((Applicative)codecBuilder, (yRot, xRot, red, green, blue, alpha, scale, duration, facesCamera, behavior) -> new RingData(yRot.floatValue(), xRot.floatValue(), (int)duration, red.floatValue(), green.floatValue(), blue.floatValue(), alpha.floatValue(), scale.floatValue(), (boolean)facesCamera, EnumRingBehavior.valueOf(behavior))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class RingFactory
    implements ParticleProvider<RingData> {
        private final SpriteSet spriteSet;

        public RingFactory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(RingData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleRing particle = new ParticleRing(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getyRot(), typeIn.getxRot(), typeIn.getDuration(), typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getAlpha(), typeIn.getScale(), typeIn.getFacesCamera(), typeIn.getBehavior());
            particle.m_108339_(this.spriteSet);
            return particle;
        }
    }
}

