/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class MachineEntity
extends EngineVehicle {
    public MachineEntity(EntityType<? extends MachineEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    public void m_8119_() {
        this.prevRoll = this.roll;
        if (this.m_20096_()) {
            this.setZRot(this.roll * 0.9f);
        } else {
            float speed = (float)this.m_20184_().m_82553_();
            this.setZRot(-this.pressingInterpolatedX.getSmooth() * this.getProperties().get(VehicleStat.ROLL_FACTOR) * speed);
        }
        super.m_8119_();
    }

    protected void updateController() {
        this.setEngineTarget(1.0f);
        this.m_146922_(this.m_146908_() - this.getProperties().get(VehicleStat.YAW_SPEED) * this.pressingInterpolatedX.getSmooth());
        if (this.m_20096_()) {
            Vector3f direction = this.getForwardDirection();
            float speed = this.getSpeed() * this.pressingInterpolatedZ.getSmooth();
            this.m_20256_(this.m_20184_().m_82549_(this.toVec3d(direction.mul(speed))));
        }
    }

    protected float getSpeed() {
        return (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED));
    }

    protected void updateVelocity() {
        float decay = 1.0f - this.getProperties().get(VehicleStat.FRICTION);
        float gravity = this.getGravity();
        if (this.f_19798_) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.m_20096_()) {
            decay = this.getProperties().get(VehicleStat.GROUND_FRICTION);
        }
        float hd = this.getProperties().get(VehicleStat.HORIZONTAL_DECAY);
        float vd = this.getProperties().get(VehicleStat.VERTICAL_DECAY);
        Vec3 velocity = this.m_20184_();
        this.m_20334_(velocity.f_82479_ * (double)decay * (double)hd, velocity.f_82480_ * (double)decay * (double)vd + (double)gravity, velocity.f_82481_ * (double)decay * (double)hd);
        float rf = decay * this.getProperties().get(VehicleStat.ROTATION_DECAY);
        this.pressingInterpolatedX.decay(0.0f, 1.0f - rf);
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - rf);
    }

    public ItemStack addItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = stack.m_41777_();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.moveItemToEmptySlots(itemStack);
        return itemStack.m_41619_() ? ItemStack.f_41583_ : itemStack;
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack)) continue;
            this.moveItemsBetweenStacks(stack, itemStack);
            if (!stack.m_41619_()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack stack, ItemStack other) {
        int i = Math.min(this.m_6893_(), other.m_41741_());
        int j = Math.min(stack.m_41613_(), i - other.m_41613_());
        if (j > 0) {
            other.m_41769_(j);
            stack.m_41774_(j);
            this.m_6596_();
        }
    }

    private void moveItemToEmptySlots(ItemStack stack) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack;
            if (!this.m_7013_(i, stack) || !(itemStack = this.m_8020_(i)).m_41619_()) continue;
            this.m_6836_(i, stack.m_278832_());
            return;
        }
    }
}

