/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.renderer;

import dev.obscuria.tooltips.client.TooltipDefinition;
import dev.obscuria.tooltips.client.TooltipLabel;
import dev.obscuria.tooltips.client.renderer.BlankComponent;
import dev.obscuria.tooltips.client.renderer.HeaderComponent;
import dev.obscuria.tooltips.client.renderer.TooltipContext;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector2ic;

public final class TooltipRenderer {
    private static ItemStack lastStack = ItemStack.f_41583_;
    private static ItemStack actualStack = ItemStack.f_41583_;
    private static TooltipContext context = new TooltipContext();

    public static void perform(ItemStack stack) {
        actualStack = stack;
        if (ItemStack.m_150942_((ItemStack)lastStack, (ItemStack)actualStack)) {
            return;
        }
        context = new TooltipContext(actualStack, TooltipDefinition.aggregateStyleFor(stack), TooltipLabel.findFor(stack));
    }

    public static boolean render(GuiGraphics graphics, Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner positioner) {
        if (actualStack.m_41619_()) {
            return false;
        }
        if (components.isEmpty()) {
            return false;
        }
        ClientTooltipComponent title = components.remove(0);
        BlankComponent label = context.label() != null ? context.label().create(actualStack) : BlankComponent.INSTANCE;
        int minWidth = TooltipRenderer.widthOf(components, font);
        components.add(0, new HeaderComponent(minWidth, !components.isEmpty(), context, title, label));
        int width = TooltipRenderer.widthOf(components, font);
        int height = TooltipRenderer.heightOf(components) - 2;
        Vector2ic pos = positioner.m_262814_(graphics.m_280182_(), graphics.m_280206_(), mouseX, mouseY, width, height);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280262_();
        context.style().panel().ifPresent(it -> it.render(graphics, pos.x(), pos.y(), width, height));
        context.style().effects().forEach(it -> it.renderBack(graphics, context, pos.x(), pos.y(), width, height));
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
        context.style().frame().ifPresent(it -> it.render(graphics, pos.x(), pos.y(), width, height));
        graphics.m_280168_().m_85849_();
        graphics.m_280262_();
        int componentY = pos.y();
        for (ClientTooltipComponent component : components) {
            component.m_142440_(font, pos.x(), componentY, graphics.m_280168_().m_85850_().m_252922_(), graphics.m_280091_());
            component.m_183452_(font, pos.x(), componentY, graphics);
            componentY += component.m_142103_();
        }
        graphics.m_280168_().m_85849_();
        lastStack = actualStack;
        actualStack = ItemStack.f_41583_;
        context.removeExpiredParticles();
        return true;
    }

    private static int widthOf(List<ClientTooltipComponent> components, Font font) {
        int max = 0;
        for (ClientTooltipComponent component : components) {
            int width = component.m_142069_(font);
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    private static int heightOf(List<ClientTooltipComponent> components) {
        int sum = 0;
        for (ClientTooltipComponent component : components) {
            sum += component.m_142103_();
        }
        return sum;
    }
}

