/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.renderer;

import dev.obscuria.tooltips.client.TooltipLabel;
import dev.obscuria.tooltips.client.TooltipStyle;
import dev.obscuria.tooltips.client.renderer.ParticleData;
import dev.obscuria.tooltips.client.renderer.ParticleStatus;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public record TooltipContext(ItemStack stack, TooltipStyle style, @Nullable TooltipLabel label, Long startTime, List<ParticleData> particles) {
    public TooltipContext(ItemStack stack, TooltipStyle style, @Nullable TooltipLabel label) {
        this(stack, style, label, Util.m_137550_(), Lists.newArrayList());
    }

    public TooltipContext() {
        this(ItemStack.f_41583_, TooltipStyle.EMPTY, null, Util.m_137550_(), Lists.newArrayList());
    }

    public float timeInSeconds() {
        return (float)(Util.m_137550_() - this.startTime) * 0.001f;
    }

    public void addParticle(ParticleData particle) {
        this.particles.add(particle);
    }

    public void forEachParticle(Object source, Consumer<ParticleData> consumer) {
        for (ParticleData particle : this.particles) {
            if (!particle.source.equals(source)) continue;
            consumer.accept(particle);
        }
    }

    public void removeExpiredParticles() {
        this.particles.removeIf(it -> it.status == ParticleStatus.EXPIRED);
    }
}

