/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.element.icon;

import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import dev.obscuria.tooltips.client.element.Transform;
import dev.obscuria.tooltips.client.element.icon.AccentBurstIcon;
import dev.obscuria.tooltips.client.element.icon.AccentIcon;
import dev.obscuria.tooltips.client.element.icon.AccentSpinIcon;
import dev.obscuria.tooltips.client.element.icon.StaticIcon;
import dev.obscuria.tooltips.client.renderer.TooltipContext;
import dev.obscuria.tooltips.registry.TooltipsRegistries;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;

public interface TooltipIcon {
    public static final Codec<TooltipIcon> DIRECT_CODEC = TooltipsRegistries.TOOLTIP_ICON_TYPE.byNameCodec().dispatch(TooltipIcon::codec, Function.identity());
    public static final Codec<TooltipIcon> CODEC = TooltipsRegistries.Resource.TOOLTIP_ICON.byNameCodec();

    public Codec<? extends TooltipIcon> codec();

    public void render(GuiGraphics var1, TooltipContext var2, int var3, int var4);

    default public void pushTransform(Transform transform, GuiGraphics graphics, TooltipContext context, int x, int y) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 150.0f);
        graphics.m_280168_().m_85837_(transform.offset().f_82479_, transform.offset().f_82480_, transform.offset().f_82481_);
        graphics.m_280168_().m_85841_(transform.scale(), transform.scale(), transform.scale());
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(transform.rotation()));
        this.applyScale(graphics, context, x, y);
        this.applyRotation(graphics, context, x, y);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(-8.0f, -8.0f, -150.0f);
    }

    default public void popTransform(GuiGraphics graphics) {
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85849_();
    }

    default public void applyScale(GuiGraphics graphics, TooltipContext context, int x, int y) {
    }

    default public void applyRotation(GuiGraphics graphics, TooltipContext context, int x, int y) {
    }

    public static void bootstrap(BiConsumer<String, Supplier<Codec<? extends TooltipIcon>>> registrar) {
        registrar.accept("static", () -> StaticIcon.CODEC);
        registrar.accept("accent", () -> AccentIcon.CODEC);
        registrar.accept("accent_spin", () -> AccentSpinIcon.CODEC);
        registrar.accept("accent_burst", () -> AccentBurstIcon.CODEC);
    }
}

