/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.api.client.stylisheffects.v1.MobEffectWidgetContext;
import fuzs.stylisheffects.client.core.ClientAbstractions;
import fuzs.stylisheffects.client.gui.effects.EffectWidget;
import fuzs.stylisheffects.client.gui.effects.RenderAreasProvider;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.client.util.ColorUtil;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEffectRenderer
implements EffectWidget,
RenderAreasProvider {
    public static final double DEFAULT_WIDGET_SCALE = 4.0;
    protected static final ResourceLocation EFFECT_BACKGROUND = new ResourceLocation("stylisheffects", "textures/gui/mob_effect_background.png");
    private final EffectRendererEnvironment environment;
    protected Object screen;
    private int availableWidth;
    private int availableHeight;
    private int startX;
    private int startY;
    private MobEffectWidgetContext.ScreenSide screenSide;
    protected List<MobEffectInstance> activeEffects;

    protected AbstractEffectRenderer(EffectRendererEnvironment environment) {
        this.environment = environment;
    }

    public void setScreenDimensions(Object screen, int availableWidth, int availableHeight, int startX, int startY, MobEffectWidgetContext.ScreenSide screenSide) {
        this.screen = screen;
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.startX = startX;
        this.startY = startY;
        this.screenSide = screenSide;
        switch (this.environment) {
            case GUI: {
                this.screenSide = this.screenSide.inverse();
                this.availableWidth -= ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetX;
                this.availableHeight -= ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetY;
                this.startX += (this.screenSide.right() ? 1 : -1) * ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetX;
                this.startY += ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetY;
                break;
            }
            case INVENTORY: {
                this.availableWidth -= ((ClientConfig.InventoryRendererConfig)this.rendererConfig()).screenBorderDistance;
            }
        }
    }

    public final void setActiveEffects(Collection<MobEffectInstance> activeEffects) {
        if (activeEffects.isEmpty()) {
            this.activeEffects = null;
            return;
        }
        this.activeEffects = activeEffects.stream().filter(this::isEffectAllowedToShow).sorted().collect(Collectors.toList());
    }

    private boolean isEffectAllowedToShow(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_267577_() && this.rendererConfig().hideInfiniteEffects) {
            return false;
        }
        if (!mobEffectInstance.m_19575_() && this.rendererConfig().respectHideParticles) {
            return false;
        }
        return ClientAbstractions.INSTANCE.isMobEffectVisibleIn(this.environment, mobEffectInstance);
    }

    public final boolean isActive() {
        return this.activeEffects != null && !this.activeEffects.isEmpty();
    }

    public final boolean isValid() {
        return !this.rendererConfig().allowFallback || this.getMaxRows() > 0 && this.getMaxColumns() > 0;
    }

    public final double getWidgetScale() {
        return this.rendererConfig().scale / 4.0;
    }

    public final int getScaledWidth() {
        return (int)((double)this.getWidth() * this.getWidgetScale());
    }

    public final int getScaledHeight() {
        return (int)((double)this.getHeight() * this.getWidgetScale());
    }

    public abstract MobEffectWidgetContext.Renderer getEffectRenderer();

    protected abstract int getBackgroundTextureX();

    protected abstract int getBackgroundTextureY();

    protected abstract int getSpriteOffsetX();

    protected abstract int getSpriteOffsetY(boolean var1);

    protected int getDurationOffsetX() {
        return this.getWidth() / 2;
    }

    protected int getDurationOffsetY() {
        return this.getHeight() - 10;
    }

    @Nullable
    public abstract EffectRendererEnvironment.Factory getFallbackRenderer();

    @Override
    public List<Rect2i> getRenderAreas() {
        return this.getEffectPositions(this.activeEffects).stream().map(Pair::getValue).map(pos -> new Rect2i(pos[0], pos[1], this.getScaledWidth(), this.getScaledHeight())).collect(Collectors.toList());
    }

    public List<Pair<MobEffectInstance, int[]>> getEffectPositions(List<MobEffectInstance> activeEffects) {
        ArrayList effectToPos = Lists.newArrayList();
        for (int counter = 0; counter < activeEffects.size(); ++counter) {
            int posX = counter % this.getMaxClampedColumns();
            int posY = counter / this.getMaxClampedColumns();
            effectToPos.add(Pair.of((Object)activeEffects.get(counter), (Object)this.coordsToEffectPosition(posX, posY)));
        }
        return effectToPos;
    }

    protected int getTopOffset() {
        return 0;
    }

    protected int[] coordsToEffectPosition(int coordX, int coordY) {
        int[] renderPositions = new int[2];
        switch (this.screenSide) {
            case LEFT: {
                renderPositions[0] = this.startX - (this.getScaledWidth() + 1) - (this.getScaledWidth() + this.rendererConfig().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
                break;
            }
            case RIGHT: {
                renderPositions[0] = this.startX + 1 + (this.getScaledWidth() + this.rendererConfig().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
            }
        }
        return renderPositions;
    }

    public void renderEffects(GuiGraphics guiGraphics, Minecraft minecraft) {
        for (Pair<MobEffectInstance, int[]> entry : this.getEffectPositions(this.activeEffects)) {
            this.renderWidget(guiGraphics, ((int[])entry.getValue())[0], ((int[])entry.getValue())[1], minecraft, (MobEffectInstance)entry.getKey());
        }
    }

    protected float getBlinkingAlpha(MobEffectInstance mobEffectInstance) {
        if (!mobEffectInstance.m_19571_() && !mobEffectInstance.m_267577_() && mobEffectInstance.m_19557_() <= 200) {
            int duration = 10 - mobEffectInstance.m_19557_() / 20;
            return Mth.m_14036_((float)((float)mobEffectInstance.m_19557_() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)mobEffectInstance.m_19557_() * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)duration / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
        }
        return 1.0f;
    }

    private int getAvailableWidth() {
        return Math.min(this.availableWidth, this.rendererConfig().maxColumns * (this.getScaledWidth() + this.rendererConfig().widgetSpaceX));
    }

    private int getAvailableHeight() {
        return Math.min(this.availableHeight, this.rendererConfig().maxRows * (this.getScaledHeight() + this.rendererConfig().widgetSpaceY));
    }

    private int getMaxColumns() {
        return this.getAvailableWidth() / (this.getScaledWidth() + this.rendererConfig().widgetSpaceX);
    }

    public int getMaxClampedColumns() {
        return Mth.m_14045_((int)this.getMaxColumns(), (int)1, (int)this.rendererConfig().maxColumns);
    }

    private int getAdjustedHeight() {
        if (this.getRows() > this.getMaxClampedRows()) {
            return (this.getAvailableHeight() - this.getScaledHeight()) / Math.max(1, this.getRows() - 1);
        }
        return this.getScaledHeight() + this.rendererConfig().widgetSpaceY;
    }

    private int getMaxRows() {
        return this.getAvailableHeight() / (this.getScaledHeight() + this.rendererConfig().widgetSpaceY);
    }

    public int getMaxClampedRows() {
        return Mth.m_14045_((int)this.getMaxRows(), (int)1, (int)this.rendererConfig().maxRows);
    }

    public int getRows() {
        return this.splitByColumns(this.activeEffects.size());
    }

    protected int splitByColumns(int amountToSplit) {
        return (int)Math.ceil((float)amountToSplit / (float)this.getMaxClampedColumns());
    }

    protected ClientConfig.EffectRendererConfig rendererConfig() {
        return switch (this.environment) {
            default -> throw new IncompatibleClassChangeError();
            case EffectRendererEnvironment.INVENTORY -> ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer();
            case EffectRendererEnvironment.GUI -> ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer();
        };
    }

    protected abstract ClientConfig.EffectWidgetConfig widgetConfig();

    @Override
    public final void renderWidget(GuiGraphics guiGraphics, int posX, int posY, Minecraft minecraft, MobEffectInstance mobEffectInstance) {
        RenderSystem.enableBlend();
        guiGraphics.m_280168_().m_85836_();
        double scale = this.getWidgetScale();
        if (scale != 1.0) {
            guiGraphics.m_280168_().m_85841_((float)scale, (float)scale, 1.0f);
            posX = (int)((double)posX / scale);
            posY = (int)((double)posY / scale);
        }
        this.drawWidgetBackground(guiGraphics, posX, posY, mobEffectInstance);
        this.drawEffectSprite(guiGraphics, posX, posY, minecraft, mobEffectInstance);
        this.drawEffectText(guiGraphics, posX, posY, minecraft, mobEffectInstance);
        this.drawEffectAmplifier(guiGraphics, posX, posY, mobEffectInstance);
        guiGraphics.m_280168_().m_85849_();
    }

    protected void drawWidgetBackground(GuiGraphics guiGraphics, int posX, int posY, MobEffectInstance mobEffectInstance) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.rendererConfig().widgetAlpha));
        int backgroundY = this.getBackgroundY(mobEffectInstance, this.widgetConfig().ambientBorder, this.widgetConfig().qualityBorder);
        guiGraphics.m_280163_(EFFECT_BACKGROUND, posX, posY, (float)this.getBackgroundTextureX(), (float)(this.getBackgroundTextureY() + backgroundY * this.getHeight()), this.getWidth(), this.getHeight(), 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawEffectSprite(GuiGraphics guiGraphics, int posX, int posY, Minecraft minecraft, MobEffectInstance mobEffectInstance) {
        if (this.drawCustomEffect(guiGraphics, posX, posY, mobEffectInstance)) {
            return;
        }
        float blinkingAlpha = this.widgetConfig().blinkingAlpha ? this.getBlinkingAlpha(mobEffectInstance) : 1.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(blinkingAlpha * (float)this.rendererConfig().widgetAlpha));
        TextureAtlasSprite atlasSprite = minecraft.m_91306_().m_118732_(mobEffectInstance.m_19544_());
        guiGraphics.m_280159_(posX + this.getSpriteOffsetX(), posY + this.getSpriteOffsetY(!this.widgetConfig().ambientDuration && mobEffectInstance.m_19571_()), 0, 18, 18, atlasSprite);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean drawCustomEffect(GuiGraphics guiGraphics, int posX, int posY, MobEffectInstance mobEffectInstance) {
        Object object = this.screen;
        if (object instanceof EffectRenderingInventoryScreen) {
            EffectRenderingInventoryScreen effectInventoryScreen = (EffectRenderingInventoryScreen)object;
            return ClientAbstractions.INSTANCE.renderInventoryIcon(mobEffectInstance, effectInventoryScreen, guiGraphics, posX, posY, 0);
        }
        object = this.screen;
        if (object instanceof Gui) {
            Gui gui = (Gui)object;
            return ClientAbstractions.INSTANCE.renderGuiIcon(mobEffectInstance, gui, guiGraphics, posX, posY, 0.0f, this.getBlinkingAlpha(mobEffectInstance) * (float)this.rendererConfig().widgetAlpha);
        }
        return false;
    }

    protected void drawEffectText(GuiGraphics guiGraphics, int posX, int posY, Minecraft minecraft, MobEffectInstance mobEffectInstance) {
        if (!this.widgetConfig().ambientDuration && mobEffectInstance.m_19571_()) {
            return;
        }
        this.getEffectDuration(mobEffectInstance).ifPresent(durationComponent -> {
            int potionColor = ColorUtil.getEffectColor(this.widgetConfig().durationColor, mobEffectInstance);
            int alpha = (int)(this.rendererConfig().widgetAlpha * 255.0) << 24;
            FormattedCharSequence text = durationComponent.m_7532_();
            int offsetX = this.getDurationOffsetX();
            int offsetY = this.getDurationOffsetY();
            guiGraphics.m_280649_(minecraft.f_91062_, text, posX + offsetX - 1 - minecraft.f_91062_.m_92724_(text) / 2, posY + offsetY, alpha, false);
            guiGraphics.m_280649_(minecraft.f_91062_, text, posX + offsetX + 1 - minecraft.f_91062_.m_92724_(text) / 2, posY + offsetY, alpha, false);
            guiGraphics.m_280649_(minecraft.f_91062_, text, posX + offsetX - minecraft.f_91062_.m_92724_(text) / 2, posY + offsetY - 1, alpha, false);
            guiGraphics.m_280649_(minecraft.f_91062_, text, posX + offsetX - minecraft.f_91062_.m_92724_(text) / 2, posY + offsetY + 1, alpha, false);
            guiGraphics.m_280649_(minecraft.f_91062_, text, posX + offsetX - minecraft.f_91062_.m_92724_(text) / 2, posY + offsetY, alpha | potionColor, false);
        });
    }

    protected void drawEffectAmplifier(GuiGraphics guiGraphics, int posX, int posY, MobEffectInstance mobEffectInstance) {
    }

    protected int getBackgroundY(MobEffectInstance mobEffectInstance, boolean showAmbient, boolean showQuality) {
        if (showAmbient && mobEffectInstance.m_19571_()) {
            return 1;
        }
        if (showQuality) {
            return mobEffectInstance.m_19544_().m_19486_() ? 2 : 3;
        }
        return 0;
    }

    protected final Optional<Component> getEffectDuration(MobEffectInstance mobEffectInstance) {
        if (this.isInfiniteDuration(mobEffectInstance)) {
            return Optional.ofNullable(this.getInfiniteDurationString()).map(Component::m_237113_);
        }
        return Optional.of(Component.m_237113_((String)this.formatEffectDuration(mobEffectInstance)));
    }

    @Nullable
    protected String getInfiniteDurationString() {
        return "\u221e";
    }

    protected boolean isInfiniteDuration(MobEffectInstance mobEffectInstance) {
        return mobEffectInstance.m_19557_() >= 72000 || mobEffectInstance.m_267577_();
    }

    protected String formatEffectDuration(MobEffectInstance mobEffectInstance) {
        return AbstractEffectRenderer.formatTickDuration(mobEffectInstance.m_19557_());
    }

    public static String formatTickDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        seconds %= 60;
        int hours = minutes / 60;
        minutes %= 60;
        if (hours > 0) {
            return String.format(Locale.ROOT, "%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ROOT, "%d:%02d", minutes, seconds);
    }

    public static String formatCompactTickDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        int days = hours / 24;
        seconds %= 60;
        minutes %= 60;
        hours %= 24;
        if (days > 0) {
            return days + "d";
        }
        if (hours > 0) {
            return hours + "h";
        }
        if (minutes > 0) {
            return minutes + "m";
        }
        return seconds + "s";
    }

    public Optional<List<Component>> getHoveredEffectTooltip(int mouseX, int mouseY, TooltipFlag tooltipFlag) {
        if (this.environment == EffectRendererEnvironment.INVENTORY && ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().hoveringTooltip) {
            return this.getHoveredEffect(mouseX, mouseY).map(mobEffectInstance -> {
                List<Component> tooltipLines = this.makeEffectTooltip((MobEffectInstance)mobEffectInstance, ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().tooltipDuration);
                ClientAbstractions.INSTANCE.onGatherEffectTooltipLines(this.buildContext((MobEffectInstance)mobEffectInstance), tooltipLines, tooltipFlag);
                return tooltipLines;
            });
        }
        return Optional.empty();
    }

    public MobEffectWidgetContext buildContext(MobEffectInstance mobEffectInstance) {
        return MobEffectWidgetContext.of(mobEffectInstance, this.getEffectRenderer(), this.screenSide);
    }

    public Optional<MobEffectInstance> getHoveredEffect(int mouseX, int mouseY) {
        for (Map.Entry entry : Lists.reverse(this.getEffectPositions(this.activeEffects))) {
            if (!this.isMouseOver(((int[])entry.getValue())[0], ((int[])entry.getValue())[1], mouseX, mouseY)) continue;
            return Optional.of((MobEffectInstance)entry.getKey());
        }
        return Optional.empty();
    }

    private boolean isMouseOver(int posX, int posY, int mouseX, int mouseY) {
        return mouseX >= posX && mouseX <= posX + this.getScaledWidth() && mouseY >= posY && mouseY <= posY + this.getScaledHeight();
    }

    protected List<Component> makeEffectTooltip(MobEffectInstance mobEffectInstance, boolean withDuration) {
        ArrayList tooltip = Lists.newArrayList();
        MutableComponent textComponent = this.getEffectDisplayName(mobEffectInstance);
        if (withDuration && !mobEffectInstance.m_267577_()) {
            textComponent.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237113_((String)"(").m_130946_(AbstractEffectRenderer.formatTickDuration(mobEffectInstance.m_19557_())).m_130946_(")").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add(textComponent);
        String descriptionKey = mobEffectInstance.m_19544_().m_19481_() + ".description";
        if (Language.m_128107_().m_6722_(descriptionKey)) {
            tooltip.add(Component.m_237115_((String)descriptionKey).m_130940_(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    protected MutableComponent getEffectDisplayName(MobEffectInstance mobEffectInstance) {
        MutableComponent textComponent = Component.m_237119_().m_7220_(mobEffectInstance.m_19544_().m_19482_());
        String translationKey = "enchantment.level." + (mobEffectInstance.m_19564_() + 1);
        if (mobEffectInstance.m_19564_() >= 1 && mobEffectInstance.m_19564_() <= 9 || Language.m_128107_().m_6722_(translationKey)) {
            textComponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)translationKey));
        }
        return textComponent;
    }
}

