/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mofusbetterend.mixins;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.mofusbetterend.endbiomes.TheEndBiomeData;
import net.mcreator.mofusbetterend.mixins.BiomeSourceMixin;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TheEndBiomeSource.class})
public class TheEndBiomeSourceMixin
extends BiomeSourceMixin {
    private List<Supplier<Object>> overrides = new ArrayList<Supplier<Object>>();
    @Unique
    private boolean biomeMapModified = false;
    @Shadow
    @Mutable
    @Final
    static Codec<TheEndBiomeSource> f_48617_;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void modifyCodec(CallbackInfo ci) {
        f_48617_ = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_255175_((ResourceKey)Registries.f_256952_)).apply((Applicative)instance, instance.stable(TheEndBiomeSource::m_254978_)));
    }

    @Inject(method={"create"}, at={@At(value="HEAD")})
    private static void rememberLookup(HolderGetter<Biome> biomes, CallbackInfoReturnable<?> ci) {
        TheEndBiomeData.biomeRegistry.set(biomes);
    }

    @Inject(method={"create"}, at={@At(value="TAIL")})
    private static void clearLookup(HolderGetter<Biome> biomes, CallbackInfoReturnable<?> ci) {
        TheEndBiomeData.biomeRegistry.remove();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Holder<Biome> centerBiome, Holder<Biome> highlandsBiome, Holder<Biome> midlandsBiome, Holder<Biome> smallIslandsBiome, Holder<Biome> barrensBiome, CallbackInfo ci) {
        HolderGetter<Biome> biomes = TheEndBiomeData.biomeRegistry.get();
        if (biomes == null) {
            throw new IllegalStateException("Biome registry not set by Mixin");
        }
        this.overrides.add((Supplier<Object>)Suppliers.memoize(() -> TheEndBiomeData.createOverrides(biomes)));
    }

    @Inject(method={"getNoiseBiome"}, at={@At(value="RETURN")}, cancellable=true)
    private void getWeightedEndBiome(int biomeX, int biomeY, int biomeZ, Climate.Sampler noise, CallbackInfoReturnable<Holder<Biome>> cir) {
        try {
            if (!this.biomeMapModified) {
                boolean first = true;
                for (Supplier<Object> mod : this.overrides) {
                    if (!first) {
                        List endbiomes = (List)mod.get().getClass().getField("endBiomesCopy").get(mod.get());
                        List midlandsbiomes = (List)mod.get().getClass().getField("midlandsBiomesCopy").get(mod.get());
                        List barrensbiomes = (List)mod.get().getClass().getField("barrensBiomesCopy").get(mod.get());
                        this.overrides.get(0).get().getClass().getMethod("addExternalModBiomes", List.class, String.class).invoke(this.overrides.get(0).get(), endbiomes, "end");
                        this.overrides.get(0).get().getClass().getMethod("addExternalModBiomes", List.class, String.class).invoke(this.overrides.get(0).get(), midlandsbiomes, "midlands");
                        this.overrides.get(0).get().getClass().getMethod("addExternalModBiomes", List.class, String.class).invoke(this.overrides.get(0).get(), barrensbiomes, "barrens");
                    }
                    first = false;
                }
                this.overrides.get(0).get().getClass().getMethod("initBiomes", new Class[0]).invoke(this.overrides.get(0).get(), new Object[0]);
                this.biomeMapModified = true;
            }
            Supplier<Object> override = this.overrides.get(0);
            Holder picked = (Holder)override.get().getClass().getMethod("pick", Integer.TYPE, Integer.TYPE, Integer.TYPE, Climate.Sampler.class, Holder.class).invoke(override.get(), biomeX, biomeY, biomeZ, noise, cir.getReturnValue());
            cir.setReturnValue((Object)picked);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Set<Holder<Biome>> modifyBiomeSet(Set<Holder<Biome>> biomes) {
        try {
            LinkedHashSet<Holder<Biome>> modifiedBiomes = new LinkedHashSet<Holder<Biome>>(biomes);
            for (Supplier<Object> override : this.overrides) {
                Field field = override.get().getClass().getField("customBiomes");
                modifiedBiomes.addAll((Set)field.get(override.get()));
            }
            return Collections.unmodifiableSet(modifiedBiomes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return biomes;
        }
    }
}

