/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.resource;

import dev.felnull.otyacraftengine.server.level.TagSerializable;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;

public class ImageInfo
implements TagSerializable {
    public static final ImageInfo EMPTY = new ImageInfo(ImageType.EMPTY, "");
    private ImageType imageType;
    private String identifier;

    public ImageInfo() {
    }

    public ImageInfo(ImageType imageType, String identifier) {
        this.imageType = imageType;
        this.identifier = identifier;
    }

    public void save(CompoundTag tag) {
        tag.m_128359_("ImageType", this.imageType.getNmae());
        tag.m_128359_("Identifier", this.identifier);
    }

    public void load(CompoundTag tag) {
        this.imageType = ImageType.getImageTypeByName(tag.m_128461_("ImageType"));
        this.identifier = tag.m_128461_("Identifier");
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.imageType == ImageType.EMPTY;
    }

    public String toString() {
        return "ImageInfo{imageType=" + String.valueOf((Object)this.imageType) + ", identifier='" + this.identifier + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageInfo imageInfo = (ImageInfo)o;
        return this.imageType == imageInfo.imageType && Objects.equals(this.identifier, imageInfo.identifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.imageType, this.identifier});
    }

    public static enum ImageType {
        EMPTY("empty"),
        URL("url"),
        PLAYER_FACE("player_face"),
        YOUTUBE_THUMBNAIL("youtube_thumbnail"),
        SOUND_CLOUD_ARTWORK("sound_cloud_artwork"),
        NETEASE_CLOUD_MUSIC_PICTURE("netease_cloud_music_picture");

        private final String name;

        private ImageType(String name) {
            this.name = name;
        }

        public String getNmae() {
            return this.name;
        }

        public static ImageType getImageTypeByName(String name) {
            for (ImageType it : ImageType.values()) {
                if (!it.getNmae().equals(name)) continue;
                return it;
            }
            return EMPTY;
        }
    }
}

