/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.lavalink.youtube.http;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.http.HttpContextRetryCounter;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.dev.lavalink.youtube.http.BaseYoutubeHttpContextFilter;
import dev.felnull.imp.include.dev.lavalink.youtube.http.YoutubeAccessTokenTracker;
import dev.felnull.imp.include.dev.lavalink.youtube.http.YoutubeOauth2Handler;
import dev.felnull.imp.include.org.apache.http.HttpResponse;
import dev.felnull.imp.include.org.apache.http.client.CookieStore;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpUriRequest;
import dev.felnull.imp.include.org.apache.http.client.protocol.HttpClientContext;
import dev.felnull.imp.include.org.apache.http.impl.client.BasicCookieStore;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import org.jetbrains.annotations.NotNull;

public class YoutubeHttpContextFilter
extends BaseYoutubeHttpContextFilter {
    private static final Logger log = LoggerFactory.getLogger(YoutubeHttpContextFilter.class);
    private static final String ATTRIBUTE_RESET_RETRY = "isResetRetry";
    public static final String ATTRIBUTE_USER_AGENT_SPECIFIED = "clientUserAgent";
    public static final String ATTRIBUTE_VISITOR_DATA_SPECIFIED = "clientVisitorData";
    private static final HttpContextRetryCounter retryCounter = new HttpContextRetryCounter("yt-token-retry");
    private YoutubeAccessTokenTracker tokenTracker;
    private YoutubeOauth2Handler oauth2Handler;

    public void setTokenTracker(@NotNull YoutubeAccessTokenTracker tokenTracker) {
        this.tokenTracker = tokenTracker;
    }

    public void setOauth2Handler(@NotNull YoutubeOauth2Handler oauth2Handler) {
        this.oauth2Handler = oauth2Handler;
    }

    @Override
    public void onContextOpen(HttpClientContext context) {
        CookieStore cookieStore = context.getCookieStore();
        if (cookieStore == null) {
            cookieStore = new BasicCookieStore();
            context.setCookieStore(cookieStore);
        }
        cookieStore.clear();
    }

    @Override
    public void onRequest(HttpClientContext context, HttpUriRequest request, boolean isRepetition) {
        if (!isRepetition) {
            context.removeAttribute(ATTRIBUTE_RESET_RETRY);
        }
        retryCounter.handleUpdate(context, isRepetition);
        if (this.tokenTracker.isTokenFetchContext(context)) {
            return;
        }
        if (this.oauth2Handler.isOauthFetchContext(context)) {
            return;
        }
        String userAgent = context.getAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED, String.class);
        if (!request.getURI().getHost().contains("googlevideo")) {
            boolean isRequestFromOauthedClient;
            if (userAgent != null) {
                request.setHeader("User-Agent", userAgent);
                String visitorData = context.getAttribute(ATTRIBUTE_VISITOR_DATA_SPECIFIED, String.class);
                request.setHeader("X-Goog-Visitor-Id", visitorData != null ? visitorData : this.tokenTracker.getVisitorId());
                context.removeAttribute(ATTRIBUTE_VISITOR_DATA_SPECIFIED);
                context.removeAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED);
            }
            boolean bl = isRequestFromOauthedClient = context.getAttribute("yt-oauth-enabled-client") == Boolean.TRUE;
            if (isRequestFromOauthedClient && "https://youtubei.googleapis.com/youtubei/v1/player?prettyPrint=false".equals(request.getURI().toString())) {
                String oauthToken = context.getAttribute("yt-oauth-token", String.class);
                if (oauthToken != null && !oauthToken.isEmpty()) {
                    this.oauth2Handler.applyToken(request, oauthToken);
                } else {
                    this.oauth2Handler.applyToken(request);
                }
            }
        }
    }

    @Override
    public boolean onRequestResponse(HttpClientContext context, HttpUriRequest request, HttpResponse response) {
        if (response.getStatusLine().getStatusCode() == 429) {
            throw new FriendlyException("This IP address has been blocked by YouTube (429).", FriendlyException.Severity.COMMON, null);
        }
        return false;
    }

    @Override
    public boolean onRequestException(HttpClientContext context, HttpUriRequest request, Throwable error) {
        if (HttpClientTools.isConnectionResetException(error) && context.getAttribute(ATTRIBUTE_RESET_RETRY) == null) {
            context.setAttribute(ATTRIBUTE_RESET_RETRY, true);
            return true;
        }
        return false;
    }
}

