/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.felnull.fnjl.math;

import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec3d;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec3i;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec4f;
import dev.felnull.imp.include.dev.felnull.fnjl.tuple.FNQuadruple;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNMath;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FNVec3f {
    private float x;
    private float y;
    private float z;

    public FNVec3f() {
    }

    public FNVec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public FNVec3f copy() {
        return new FNVec3f(this.x, this.y, this.z);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public double distance(@NotNull FNVec3f vec) {
        return Math.sqrt(Math.pow(this.x - vec.getX(), 2.0) + Math.pow(this.y - vec.getY(), 2.0) + Math.pow(this.z - vec.getZ(), 2.0));
    }

    public FNVec3f add(@NotNull FNVec3f vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        this.z += vec.getZ();
        return this;
    }

    public FNVec3f sub(@NotNull FNVec3f vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        this.z -= vec.getZ();
        return this;
    }

    public FNVec3f radians() {
        this.x = (float)Math.toRadians(this.x);
        this.y = (float)Math.toRadians(this.y);
        this.z = (float)Math.toRadians(this.z);
        return this;
    }

    public FNVec3f degrees() {
        this.x = (float)Math.toDegrees(this.x);
        this.y = (float)Math.toDegrees(this.y);
        this.z = (float)Math.toDegrees(this.z);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec3f fnVec3f = (FNVec3f)o;
        return Float.compare(fnVec3f.x, this.x) == 0 && Float.compare(fnVec3f.y, this.y) == 0 && Float.compare(fnVec3f.z, this.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public String toString() {
        return "FNVec3f{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }

    public FNVec3d convertDouble() {
        return new FNVec3d(this.x, this.y, this.z);
    }

    public FNVec3i convertInt() {
        return new FNVec3i((int)this.x, (int)this.y, (int)this.z);
    }

    public FNVec4f toQuaternion() {
        FNQuadruple<Double, Double, Double, Double> q = FNMath.toQuaternion(this.x, this.y, this.z);
        double qx = q.getLeft();
        double qy = q.getLeftCenter();
        double qz = q.getRightCenter();
        double qw = q.getRight();
        return new FNVec4f((float)qx, (float)qy, (float)qz, (float)qw);
    }
}

