/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class DirectBufferStreamBroker {
    private final byte[] copyBuffer;
    private final int initialSize;
    private int readByteCount;
    private ByteBuffer currentBuffer;

    public DirectBufferStreamBroker(int initialSize) {
        this.initialSize = initialSize;
        this.copyBuffer = new byte[512];
        this.currentBuffer = ByteBuffer.allocateDirect(initialSize);
    }

    public void resetAndCompact() {
        this.currentBuffer = ByteBuffer.allocateDirect(this.initialSize);
    }

    public void clear() {
        this.currentBuffer.clear();
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buffer = this.currentBuffer.duplicate();
        buffer.flip();
        return buffer;
    }

    public boolean isTruncated() {
        return this.currentBuffer.position() < this.readByteCount;
    }

    public byte[] extractBytes() {
        byte[] data = new byte[this.currentBuffer.position()];
        this.currentBuffer.position(0);
        this.currentBuffer.get(data, 0, data.length);
        return data;
    }

    public boolean consumeNext(InputStream inputStream, int maximumSavedBytes, int maximumReadBytes) throws IOException {
        this.currentBuffer.clear();
        this.readByteCount = 0;
        this.ensureCapacity(Math.min(maximumSavedBytes, inputStream.available()));
        while (this.readByteCount < maximumReadBytes) {
            int maximumReadFragment = Math.min(this.copyBuffer.length, maximumReadBytes - this.readByteCount);
            int fragmentLength = inputStream.read(this.copyBuffer, 0, maximumReadFragment);
            if (fragmentLength == -1) {
                return true;
            }
            int bytesToSave = Math.min(fragmentLength, maximumSavedBytes - this.readByteCount);
            if (bytesToSave <= 0) continue;
            this.ensureCapacity(this.currentBuffer.position() + bytesToSave);
            this.currentBuffer.put(this.copyBuffer, 0, bytesToSave);
        }
        return false;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.currentBuffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.currentBuffer.capacity() << 1);
            this.currentBuffer.flip();
            newBuffer.put(this.currentBuffer);
            this.currentBuffer = newBuffer;
        }
    }
}

