/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitStreamReader {
    private final InputStream stream;
    private int currentByte;
    private int bitsLeft;

    public BitStreamReader(InputStream stream) {
        this.stream = stream;
    }

    public long asLong(int bitsNeeded) throws IOException {
        long value = 0L;
        while (bitsNeeded > 0) {
            this.fill();
            int chunk = Math.min(bitsNeeded, this.bitsLeft);
            int mask = (1 << chunk) - 1;
            value <<= chunk;
            value |= (long)(this.currentByte >> this.bitsLeft - chunk & mask);
            bitsNeeded -= chunk;
            this.bitsLeft -= chunk;
        }
        return value;
    }

    public long asSignedLong(int bitsNeeded) throws IOException {
        long value = this.asLong(bitsNeeded);
        if ((value & 1L << bitsNeeded - 1) != 0L) {
            return value | (1L << bitsNeeded) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return value;
    }

    public int asInteger(int bitsNeeded) throws IOException {
        return Math.toIntExact(this.asLong(bitsNeeded));
    }

    public int asSignedInteger(int bitsNeeded) throws IOException {
        return Math.toIntExact(this.asSignedLong(bitsNeeded));
    }

    public int readAllZeroes() throws IOException {
        int count = 0;
        this.fill();
        while ((this.currentByte & 1 << --this.bitsLeft) == 0) {
            ++count;
            this.fill();
        }
        return count;
    }

    public int readRemainingBits() {
        int value = this.currentByte & (1 << this.bitsLeft) - 1;
        this.bitsLeft = 0;
        return value;
    }

    private void fill() throws IOException {
        if (this.bitsLeft == 0) {
            this.currentByte = this.readByte();
            this.bitsLeft = 8;
            if (this.currentByte == -1) {
                throw new EOFException("Bit stream needs more bytes");
            }
        }
    }

    protected int readByte() throws IOException {
        return this.stream.read();
    }
}

