/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class FutureTools {
    private static final Logger log = LoggerFactory.getLogger(FutureTools.class);

    public static <T> List<T> awaitList(CompletionService<T> completionService, List<Future<AudioTrack>> futures) {
        int received = 0;
        boolean failed = false;
        while (received < futures.size() && !failed) {
            try {
                completionService.take();
                ++received;
            }
            catch (InterruptedException e2) {
                log.debug("Received an interruption while taking item ", e2);
                failed = true;
            }
            catch (Exception e3) {
                log.debug("Some error occurred while getting futures", e3);
                failed = true;
            }
        }
        try {
            return futures.stream().filter(Future::isDone).map(e -> {
                try {
                    return (AudioTrack)e.get();
                }
                catch (Exception ex) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e4) {
            log.debug("Some error occurred while getting futures", e4);
            return Collections.emptyList();
        }
    }
}

